/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ConversationNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TSubConversation;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTSubConversation;

class TSubConversationImpl extends
		AbstractTConversationNodeImpl<EJaxbTSubConversation> implements
		TSubConversation {

	protected TSubConversationImpl(XmlContext xmlContext,
			EJaxbTSubConversation jaxbModel) {
		super(xmlContext, jaxbModel);

	}

	@Override
	protected Class<? extends EJaxbTSubConversation> getCompliantModelClass() {
		return EJaxbTSubConversation.class;
	}

	@Override
	public ConversationNode[] getConversationNode() {
		ConversationNode[] result = new ConversationNode[getModelObject().getConversationNode().size()];
		for(int i=0; i<result.length; i++){
			result[i] = (ConversationNode)this.getXmlContext().getXmlObjectFactory()
							.wrap(this.getModelObject().getConversationNode().get(i));
		}
		return result;
	}

	@Override
	public boolean hasConversationNode() {
		return this.getModelObject().isSetConversationNode();
	}

	@Override
	public void unsetConversationNode() {
		this.getModelObject().unsetConversationNode();
	}

}
