/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybox.easybpmn.bpmn20diagram.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.type.TDiagram;

import easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.EJaxbDiagram;

abstract class AbstractTDiagramImpl<Model extends EJaxbDiagram>
extends AbstractJaxbXmlObjectImpl<Model> implements TDiagram{

	protected AbstractTDiagramImpl(XmlContext xmlContext, Model jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);
	}

	@Override
	public boolean hasName() {
		return this.getModelObject().isSetName();
	}

	@Override
	public String getDocumentation() {
		
		return this.getModelObject().getDocumentation();
	}

	@Override
	public void setDocumentation(String value) {
		this.getModelObject().setDocumentation(value);
		
	}

	@Override
	public boolean hasDocumentation() {
		return this.getModelObject().isSetDocumentation();
	}

	@Override
	public double getResolution() {
		if(getModelObject().isSetResolution()){
			return this.getModelObject().getResolution();
		}
		else{
			return 1.0;
		}
	}

	@Override
	public void setResolution(double value) {
		this.getModelObject().setResolution(value);
		
	}

	@Override
	public boolean hasResolution() {
		return this.getModelObject().isSetResolution();
	}

	@Override
	public void unsetResolution() {
		this.getModelObject().unsetResolution();
		
	}

	@Override
	public String getId() {
		return this.getModelObject().getId();
	}

	@Override
	public void setId(String value) {
		this.getModelObject().setId(value);
		
	}

}
