/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybox.easybpmn.bpmn20diagram.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.Point;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.type.TEdge;

import easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.EJaxbEdge;
import easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.EJaxbPoint;

abstract class AbstractTEdgeImpl<Model extends EJaxbEdge>
extends AbstractTDiagramElementImpl<Model> implements TEdge{


	protected AbstractTEdgeImpl(XmlContext xmlContext, Model jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	public Point[] getWaypoint() {
		return createChildrenArray(getModelObject().getWaypoint(), EJaxbPoint.class, ANY_QNAME, PointImpl.class);
	}


	public void unsetWaypoint() {
		this.getModelObject().unsetWaypoint();
	}

	@Override
	public boolean hasWaypoint() {
		return this.getModelObject().isSetWaypoint();
	}

	@Override
	public void addWayPoint(Point point) {
		this.getModelObject().getWaypoint().add(((PointImpl)point).getModelObject());
	}

	@Override
	public void removeWayPoint(Point point) {
		this.getModelObject().getWaypoint().remove(((PointImpl)point).getModelObject());
	}

}
