/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybox.easybpmn.bpmn20diagram.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNLabel;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.type.TBPMNEdge;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.type.TMessageVisibleKind;

import easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.EJaxbBPMNEdge;
import easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.EJaxbMessageVisibleKind;

public class TBPMNEdgeImpl extends AbstractTLabeledEdgeImpl<EJaxbBPMNEdge> implements TBPMNEdge{

	protected TBPMNEdgeImpl(XmlContext xmlContext, EJaxbBPMNEdge jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbBPMNEdge> getCompliantModelClass() {
		return EJaxbBPMNEdge.class;
	}

	@Override
	public BPMNLabel getBPMNLabel() {
		if(this.getModelObject().getBPMNLabel()!=null){
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getBPMNLabel(), BPMNLabelImpl.class);
		}
		return null;
	}

	@Override
	public QName getBpmnElement() {
		return this.getModelObject().getBpmnElement();
	}

	@Override
	public TMessageVisibleKind getMessageVisibleKind() {
		if(this.getModelObject().getMessageVisibleKind()!=null){
			switch(this.getModelObject().getMessageVisibleKind()){
			case INITIATING:
				return TMessageVisibleKind.initiating;
			case NON_INITIATING:
				return TMessageVisibleKind.non_initiating;
			}
		}
		return null;
	}

	@Override
	public QName getSourceElement() {
		return this.getModelObject().getSourceElement();
	}

	@Override
	public QName getTargetElement() {
		return this.getModelObject().getTargetElement();
	}

	@Override
	public boolean hasBpmnElement() {
		return this.getModelObject().isSetBpmnElement();
	}

	@Override
	public boolean hasMessageVisibleKind() {
		return this.getModelObject().isSetMessageVisibleKind();
	}

	@Override
	public boolean hasSourceElement() {
		return this.getModelObject().isSetSourceElement();
	}

	@Override
	public boolean hasTargetElement() {
		return this.getModelObject().isSetTargetElement();
	}

	@Override
	public boolean hasBPMNLabel() {
		return this.getModelObject().isSetBPMNLabel();
	}

	@Override
	public void setBPMNLabel(BPMNLabel value) {
		if(value!=null){
			this.getModelObject().setBPMNLabel(((BPMNLabelImpl)value).getModelObject());
		}
		else{
			this.getModelObject().setBPMNLabel(null);
		}
	}

	@Override
	public void setBpmnElement(QName value) {
		this.getModelObject().setBpmnElement(value);
	}

	@Override
	public void setMessageVisibleKind(TMessageVisibleKind value) {
		EJaxbMessageVisibleKind mvk = null;
		if(value!=null){
			switch(value){
			case initiating:
				mvk = EJaxbMessageVisibleKind.INITIATING;
				break;
			case non_initiating:
				mvk = EJaxbMessageVisibleKind.NON_INITIATING;
				break;
			}
		}
		this.getModelObject().setMessageVisibleKind(mvk);
	}

	@Override
	public void setSourceElement(QName value) {
		this.getModelObject().setSourceElement(value);
	}

	@Override
	public void setTargetElement(QName value) {
		this.getModelObject().setTargetElement(value);
	}
	
}
