/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybox.easybpmn.bpmn20diagram.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.type.TPoint;

import easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.EJaxbPoint;

public class TPointImpl extends AbstractJaxbXmlObjectImpl<EJaxbPoint> implements TPoint{

	protected TPointImpl(XmlContext xmlContext, EJaxbPoint jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbPoint> getCompliantModelClass() {
		return EJaxbPoint.class;
	}

	@Override
	public double getX() {
		return this.getModelObject().getX();
	}

	@Override
	public double getY() {
		return this.getModelObject().getY();
	}

	@Override
	public boolean hasX() {
		return this.getModelObject().isSetX();
	}

	@Override
	public boolean hasY() {
		return this.getModelObject().isSetY();
	}

	@Override
	public void setX(double value) {
		this.getModelObject().setX(value);
	}

	@Override
	public void setY(double value) {
		this.getModelObject().setY(value);
	}

	
}
