/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybox.easybpmn.bpmn20diagram.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.Constants;


public final class XmlObjectSchemaBindingImpl extends AbstractXmlObjectSchemaBindingImpl {

	@Override
	public String getOriginatingSchemaDir() {
		return "schema/bpmn20diagram";
	}

	@Override
	public String getOriginatingSchemaName() {
		return "bpmn20diagram.xsd";
	}



	@Override
	public Package getModelObjectPackage() {
		return easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.ObjectFactory.class.getPackage();
	}


	@Override
	public String getOriginatingSchemaNamespaceURI() {
		return Constants.DATAMODEL_NS_URI;
	}


	@SuppressWarnings("unchecked")
	@Override
	public Class[] getFactorableClasses() {
		List<Class> factorableClasses = new ArrayList<Class>();
		
		factorableClasses.add(BoundsImpl.class);
		factorableClasses.add(PointImpl.class);
		factorableClasses.add(FontImpl.class);
		
		factorableClasses.add(ExtensionImpl.class);
		
		factorableClasses.add(BPMNDiagramImpl.class);
		factorableClasses.add(BPMNEdgeImpl.class);
		factorableClasses.add(BPMNLabelImpl.class);
		factorableClasses.add(BPMNLabelStyleImpl.class);
		factorableClasses.add(BPMNPlaneImpl.class);
		factorableClasses.add(BPMNShapeImpl.class);
		
		return factorableClasses.toArray(new Class[factorableClasses.size()]);
	}


	@Override
	protected XmlObject doWrap(XmlContext xmlContext,
			Constructor<? extends XmlObject> xmlObjectImplConstructor,
			ModelObject ModelObjectObject)
	throws InstantiationException, IllegalAccessException,
	InvocationTargetException {
		return (XmlObject)xmlObjectImplConstructor.newInstance(xmlContext, ModelObjectObject);
	}

	@Override
	public String getOriginatingSchemaPreferredNamespacePrefix() {
		return "bpmndi";
	}

	@Override
	public String getName() {
		return "bpmn20diagram-impl";
	}


}
