/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybox.easybpmn.bpmn20diagram.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNLabelStyle;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNPlane;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.type.TBPMNDiagram;

import easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.EJaxbBPMNDiagram;
import easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.EJaxbBPMNLabelStyle;

class TBPMNDiagramImpl extends
		AbstractTDiagramImpl<EJaxbBPMNDiagram> implements
		TBPMNDiagram {

	protected TBPMNDiagramImpl(XmlContext xmlContext, EJaxbBPMNDiagram jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public BPMNPlane getBPMNPlane() {
		return this.getXmlContext().getXmlObjectFactory().wrap(this.getModelObject().getBPMNPlane(), BPMNPlaneImpl.class);
	}

	@Override
	public void setBPMNPlane(BPMNPlane value) {
		this.getModelObject().setBPMNPlane(((BPMNPlaneImpl)value).getModelObject());
	}

	@Override
	public boolean hasBPMNPlane() {
		return this.getModelObject().isSetBPMNPlane();
	}

	@Override
	public BPMNLabelStyle[] getBPMNLabelStyle() {
		return createChildrenArray(getModelObject().getBPMNLabelStyle(), EJaxbBPMNLabelStyle.class, ANY_QNAME, BPMNLabelStyleImpl.class);
	}

	@Override
	public boolean hasBPMNLabelStyle() {
		return this.getModelObject().isSetBPMNLabelStyle();
	}

	@Override
	public void unsetBPMNLabelStyle() {
		this.getModelObject().unsetBPMNLabelStyle();
	}
	
	@Override
	public void addBPMNLabelStyle(BPMNLabelStyle value) {
		this.getModelObject().getBPMNLabelStyle().add(((BPMNLabelStyleImpl)value).getModelObject());
	}

	@Override
	public void removeBPMNLabelStyle(BPMNLabelStyle value) {
		this.getModelObject().getBPMNLabelStyle().remove(((BPMNLabelStyleImpl)value).getModelObject());
	}

	@Override
	protected Class<? extends EJaxbBPMNDiagram> getCompliantModelClass() {
		return EJaxbBPMNDiagram.class;
	}


}
