/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybox.easybpmn.bpmn20diagram.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNEdge;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNShape;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.DiagramElement;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.type.TBPMNPlane;

import easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.EJaxbBPMNPlane;

public class TBPMNPlaneImpl extends AbstractTPlaneImpl<EJaxbBPMNPlane> implements TBPMNPlane{

	protected TBPMNPlaneImpl(XmlContext xmlContext, EJaxbBPMNPlane jaxbModel) {
		super(xmlContext, jaxbModel);
	}
	
	@Override
	public BPMNShape[] getBPMNShapes(){
		List<BPMNShape> l = new ArrayList<BPMNShape>();
		for(DiagramElement de : getDiagramElement()){
			if(de instanceof BPMNShape){
				l.add((BPMNShape)de);
			}
		}
		BPMNShape[] result = new BPMNShape[l.size()];
		for(int i=0; i<l.size(); i++){
			result[i] = l.get(i);
		}
		return result;
	}
	
	@Override
	public BPMNEdge[] getBPMNEdges(){
		List<BPMNEdge> l = new ArrayList<BPMNEdge>();
		for(DiagramElement de : getDiagramElement()){
			if(de instanceof BPMNEdge){
				l.add((BPMNEdge)de);
			}
		}
		BPMNEdge[] result = new BPMNEdge[l.size()];
		for(int i=0; i<l.size(); i++){
			result[i] = l.get(i);
		}
		return result;
	}

	@Override
	protected Class<? extends EJaxbBPMNPlane> getCompliantModelClass() {
		return EJaxbBPMNPlane.class;
	}

	@Override
	public QName getBpmnElement() {
		return this.getModelObject().getBpmnElement();
	}

	@Override
	public boolean hasBpmnElement() {
		return this.getModelObject().isSetBpmnElement();
	}

	@Override
	public void setBpmnElement(QName value) {
		this.getModelObject().setBpmnElement(value);
	}

}
