/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybox.easybpmn.bpmn20diagram.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNLabel;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.type.TBPMNShape;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.type.TParticipantBandKind;

import easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.EJaxbBPMNShape;
import easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.EJaxbParticipantBandKind;

public class TBPMNShapeImpl extends AbstractTLabeledShapeImpl<EJaxbBPMNShape> implements TBPMNShape{

	protected TBPMNShapeImpl(XmlContext xmlContext, EJaxbBPMNShape jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbBPMNShape> getCompliantModelClass() {
		return EJaxbBPMNShape.class;
	}
	
	@Override
	public BPMNLabel getBPMNLabel() {
		if(this.getModelObject().getBPMNLabel()!=null){
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getBPMNLabel(), BPMNLabelImpl.class);
		}
		return null;
	}

	@Override
	public QName getBpmnElement() {
		return this.getModelObject().getBpmnElement();
	}

	@Override
	public QName getChoreographyActivityShape() {
		return this.getModelObject().getChoreographyActivityShape();
	}

	@Override
	public TParticipantBandKind getParticipantBandKind() {
		if(this.getModelObject().getParticipantBandKind()!=null){
			switch (this.getModelObject().getParticipantBandKind()) {
			case BOTTOM_INITIATING:
				return TParticipantBandKind.bottom_initiating;

			case BOTTOM_NON_INITIATING:
				return TParticipantBandKind.bottom_non_initiating;
				
			case MIDDLE_INITIATING:
				return TParticipantBandKind.middle_initiating;

			case MIDDLE_NON_INITIATING:
				return TParticipantBandKind.middle_non_initiating;
				
			case TOP_INITIATING:
				return TParticipantBandKind.top_initiating;
				
			case TOP_NON_INITIATING:
				return TParticipantBandKind.top_non_initiating;
			}
		}
		return null;
	}

	@Override
	public boolean hasBPMNLabel() {
		return this.getModelObject().isSetBPMNLabel();
	}

	@Override
	public boolean hasBpmnElement() {
		return this.getModelObject().isSetBpmnElement();
	}

	@Override
	public boolean hasChoreographyActivityShape() {
		return this.getModelObject().isSetChoreographyActivityShape();
	}

	@Override
	public boolean hasIsExpanded() {
		return this.getModelObject().isSetIsExpanded();
	}

	@Override
	public boolean hasIsHorizontal() {
		return this.getModelObject().isSetIsHorizontal();
	}

	@Override
	public boolean hasIsMarkerVisible() {
		return this.getModelObject().isSetIsMarkerVisible();
	}

	@Override
	public boolean hasIsMessageVisible() {
		return this.getModelObject().isSetIsMessageVisible();
	}

	@Override
	public boolean hasParticipantBandKind() {
		return this.getModelObject().isSetParticipantBandKind();
	}

	@Override
	public boolean isIsExpanded() {
		if(this.getModelObject().isSetIsExpanded()){
			return this.getModelObject().isIsExpanded();
		}
		else{
			return true;
		}
	}

	@Override
	public boolean isIsHorizontal() {
		if(this.getModelObject().isSetIsHorizontal()){
			return this.getModelObject().isIsHorizontal();
		}
		else{
			return true;
		}
	}

	@Override
	public boolean isIsMarkerVisible() {
		if(this.getModelObject().isSetIsMarkerVisible()){
			return this.getModelObject().isIsMarkerVisible();
		}
		else{
			return true;
		}
	}

	@Override
	public boolean isIsMessageVisible() {
		if(this.getModelObject().isSetIsMessageVisible()){
			return this.getModelObject().isIsMessageVisible();
		}
		else{
			return false;
		}
	}

	@Override
	public void setBPMNLabel(BPMNLabel value) {
		if(value!=null){
			this.getModelObject().setBPMNLabel(((BPMNLabelImpl)value).getModelObject());
		}
		else{
			this.getModelObject().setBPMNLabel(null);
		}
	}

	@Override
	public void setBpmnElement(QName value) {
		this.getModelObject().setBpmnElement(value);
	}

	@Override
	public void setChoreographyActivityShape(QName value) {
		this.getModelObject().setChoreographyActivityShape(value);
	}

	@Override
	public void setIsExpanded(boolean value) {
		this.getModelObject().setIsExpanded(value);
	}

	@Override
	public void setIsHorizontal(boolean value) {
		this.getModelObject().setIsHorizontal(value);
	}

	@Override
	public void setIsMarkerVisible(boolean value) {
		this.getModelObject().setIsMarkerVisible(value);
	}

	@Override
	public void setIsMessageVisible(boolean value) {
		this.getModelObject().setIsMessageVisible(value);
	}

	@Override
	public void setParticipantBandKind(TParticipantBandKind value) {
		EJaxbParticipantBandKind pbk = null;
		if(value!=null){
		switch (value) {
			case bottom_initiating:
				pbk = EJaxbParticipantBandKind.BOTTOM_INITIATING;
				break;
			
			case bottom_non_initiating:
				pbk = EJaxbParticipantBandKind.BOTTOM_NON_INITIATING;
				break;
				
			case middle_initiating:
				pbk = EJaxbParticipantBandKind.MIDDLE_INITIATING;
				break;
				
			case middle_non_initiating:
				pbk = EJaxbParticipantBandKind.MIDDLE_NON_INITIATING;
				break;
				
			case top_initiating:
				pbk = EJaxbParticipantBandKind.TOP_INITIATING;
				break;
				
			case top_non_initiating:
				pbk = EJaxbParticipantBandKind.TOP_NON_INITIATING;
				break;
			}
		}
		this.getModelObject().setParticipantBandKind(pbk);
	}

	@Override
	public void unsetIsExpanded() {
		this.getModelObject().unsetIsExpanded();
	}

	@Override
	public void unsetIsHorizontal() {
		this.getModelObject().unsetIsHorizontal();
	}

	@Override
	public void unsetIsMarkerVisible() {
		this.getModelObject().unsetIsMarkerVisible();
	}

	@Override
	public void unsetIsMessageVisible() {
		this.getModelObject().unsetIsMessageVisible();
	}

}
