/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybox.easybpmn.bpmn20diagram.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.type.TFont;

import easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.dc.EJaxbFont;

public class TFontImpl extends AbstractJaxbXmlObjectImpl<EJaxbFont> implements TFont{

	protected TFontImpl(XmlContext xmlContext, EJaxbFont jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbFont> getCompliantModelClass() {
		return EJaxbFont.class;
	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public double getSize() {
		if(this.getModelObject().isSetSize()){
			return this.getModelObject().getSize();
		}
		else{
			return -1.0;
		}
	}

	@Override
	public boolean hasIsBold() {
		return this.getModelObject().isSetIsBold();
	}

	@Override
	public boolean hasIsItalic() {
		return this.getModelObject().isSetIsItalic();
	}

	@Override
	public boolean hasIsStrikeThrough() {
		return this.getModelObject().isSetIsStrikeThrough();
	}

	@Override
	public boolean hasIsUnderline() {
		return this.getModelObject().isSetIsUnderline();
	}

	@Override
	public boolean hasName() {
		return this.getModelObject().isSetName();
	}

	@Override
	public boolean hasSize() {
		return this.getModelObject().isSetSize();
	}

	@Override
	public boolean isIsBold() {
		if(this.getModelObject().isSetIsBold()){
			return this.getModelObject().isIsBold();
		}
		else{
			return false;
		}
	}

	@Override
	public boolean isIsItalic() {
		if(this.getModelObject().isSetIsItalic()){
			return this.getModelObject().isIsItalic();
		}
		else{
			return false;
		}
	}

	@Override
	public boolean isIsStrikeThrough() {
		if(this.getModelObject().isSetIsStrikeThrough()){
			return this.getModelObject().isIsStrikeThrough();
		}
		else{
			return false;
		}
	}

	@Override
	public boolean isIsUnderline() {
		if(this.getModelObject().isSetIsUnderline()){
			return this.getModelObject().isIsUnderline();
		}
		else{
			return false;
		}
	}

	@Override
	public void setIsBold(boolean value) {
		this.getModelObject().setIsBold(value);
	}

	@Override
	public void setIsItalic(boolean value) {
		this.getModelObject().setIsItalic(value);
	}

	@Override
	public void setIsStrikeThrough(boolean value) {
		this.getModelObject().setIsStrikeThrough(value);
	}

	@Override
	public void setIsUnderline(boolean value) {
		this.getModelObject().setIsUnderline(value);
	}

	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);
	}

	@Override
	public void setSize(double value) {
		this.getModelObject().setSize(value);
	}

	@Override
	public void unsetIsBold() {
		this.getModelObject().unsetIsBold();
	}

	@Override
	public void unsetIsItalic() {
		this.getModelObject().unsetIsItalic();
	}

	@Override
	public void unsetIsStrikeThrough() {
		this.getModelObject().unsetIsStrikeThrough();
	}

	@Override
	public void unsetIsUnderline() {
		this.getModelObject().unsetIsUnderline();
	}

	@Override
	public void unsetSize() {
		this.getModelObject().unsetSize();
	}

}
