package com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Service;


public class WSDLGeneratorHelper {
    
    public static final String PLTSuffix = "PLT";
    private static Map<String, Definitions> definitions;
    private static XmlContext context = new XmlContextFactory().newContext();
    
    public static void init() {
        definitions = new HashMap<String, Definitions>();
    }
    
    public static Definitions getOrCreateDefinitions(String tns) {
        if(definitions.containsKey(tns)) {
            return definitions.get(tns);
        }
        Definitions res = context.getXmlObjectFactory().create(Definitions.class);
        res.setTargetNamespace(tns);
        definitions.put(tns, res);
        return res;
    }
    
    public static Definitions getDefinitions(String tns) {
        return definitions.get(tns);
    }
    
    public static Collection<Definitions> getAllDefinitions() {
        return definitions.values();
    }

    public static String getArtefactNamespace(String targetNamespace) {
        String artefactNS = null;
        if(targetNamespace.endsWith("/")) {
            artefactNS = targetNamespace + "artefacts";
        } else {
            artefactNS = targetNamespace + "/artefacts";
        }
        return artefactNS;
    }
    
    
//    public static PortType findInterfaceInImports(QName itfQname, com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions bpmnDefinitions) throws BPMNException {
//        for(Import impt : bpmnDefinitions.getImports()) {
//            if(impt.getNamespace().equals(itfQname.getNamespaceURI())
//                    && impt.isWSDL11Import()) {
//                Definitions defs = impt.getWSDL11Definitions();
//                PortType pt = defs.getPortTypeByName(itfQname.getLocalPart());
//                if(pt!=null){
//                    return pt;
//                }
//            }
//        }
//        return null;
//    }
    
    public static Definitions findDefinitionsContainingInterfaceInImports(QName itfQname, com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions bpmnDefinitions) throws BPMNException {
      for(Import impt : bpmnDefinitions.getImports()) {
          if(impt.getNamespace().equals(itfQname.getNamespaceURI())
                  && impt.isWSDL11Import()) {
              Definitions defs = impt.getWSDL11Definitions();
              PortType pt = defs.getPortTypeByName(itfQname.getLocalPart());
              if(pt!=null){
                  return defs;
              }
          }
      }
      return null;
  }
    
    public static Port findPortInImports(QName portQname, com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions bpmnDefinitions) throws BPMNException {
        for(Import impt : bpmnDefinitions.getImports()) {
            if(impt.getNamespace().equals(portQname.getNamespaceURI())
                    && impt.isWSDL11Import()) {
                Definitions defs = impt.getWSDL11Definitions();
                for(Service service : defs.getServices()) {
                    Port port = service.getPortByName(portQname.getLocalPart());
                    if(port!=null) {
                        return port;
                    }
                }
            }
        }
        return null;
    }
    
    
}
