package com.ebmwebsourcing.easybpmn.bpmn2bpel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ExclusiveGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Gateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SequenceFlow;
import com.ebmwebsourcing.easyplnk20.api.element.PartnerLinkType;

public class GenerationProperties {

    private XmlContext context;
    
	private Definitions defs = null;
	private Participant participant;
	private BPELProcess bpelProcess = null;
	private Set<QName> elementsToImport = new HashSet<QName>();
	private Map<PartnerLinkType,Participant> partnerLinkTypes = new HashMap<PartnerLinkType,Participant>();

	private List<Gateway> gatewaysAlreadyGenerated = new ArrayList<Gateway>();
	
	private Map<String,String> variableMapping = new HashMap<String,String>();
	private Set<BPELVariable<?>> initializedVariables = new HashSet<BPELVariable<?>>();

	private List<Gateway> alreadyGeneratedLoops = new ArrayList<Gateway>();
    private List<ExclusiveGateway> alreadyGeneratedLoopExit = new ArrayList<ExclusiveGateway>();
	private Map<Gateway,Set<SequenceFlow>> loopers = null;
	private Activity currentWhileParent;

	public GenerationProperties(Definitions defs) {
		this.defs = defs;
	}

	public boolean isLoopDiverger(Gateway g){
		return loopers.containsKey(g);
	}

	public Set<SequenceFlow> getLoopingFlows(ExclusiveGateway eg){
		return loopers.get(eg);
	}

	public FlowElement getLoopExit(Gateway g){
		Set<SequenceFlow> sfs = loopers.get(g);
		for(FlowElement elt : g.getOutgoingFlowNodes()){
			boolean none = true;	
			for(SequenceFlow sf : sfs){
				if(sf.getTargetRef().getId().equals(elt.getId())){
					none = false;
					break;
				}
			}
			if(none){
				return elt;
			}
		}
		return null;
	}
	
	public <T extends XmlObject> T newInstance(Class<T> clazz){
	    if(context==null){
	        context = new XmlContextFactory().newContext();
	    }
	    return context.getXmlObjectFactory().create(clazz);
	}

	
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	public void setLoopers(Map<Gateway, Set<SequenceFlow>> loopers) {
		this.loopers = loopers;
	}
	public BPELProcess getBpelProcess() {
		return bpelProcess;
	}
	public void setBpelProcess(BPELProcess bpelProcess) {
		this.bpelProcess = bpelProcess;
	}
	public Definitions getBPMNDefinitions() {
		return defs;
	}
	public void setBPMNDefinitions(Definitions definitions) {
		this.defs = definitions;
	}
	public List<Gateway> getGatewaysAlreadyGenerated() {
		return gatewaysAlreadyGenerated;
	}
	public List<Gateway> getAlreadyGeneratedLoops() {
		return alreadyGeneratedLoops;
	}
	public List<ExclusiveGateway> getAlreadyGeneratedLoopExit() {
		return alreadyGeneratedLoopExit;
	}
	public Activity getCurrentWhileParent() {
		return currentWhileParent;
	}
	public void setCurrentWhileParent(Activity currentWhileParent) {
		this.currentWhileParent = currentWhileParent;
	}
    public Set<QName> getElementsToImport() {
        return elementsToImport;
    }
    public Map<PartnerLinkType,Participant> getPartnerLinkTypes() {
        return partnerLinkTypes;
    }
	public Set<BPELVariable<?>> getInitializedVariables() {
		return initializedVariables;
	}
	public Map<String, String> getVariableMapping() {
		return variableMapping;
	}
	public Participant getCurrentParticipant() {
		return participant;
	}
	public void setCurrentParticipant(Participant participant) {
		this.participant = participant;
	}
	
}
