/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.io;

import com.ebmwebsourcing.easycommons.io.FileSystemHelper;
import com.ebmwebsourcing.easycommons.io.ZipHelper;
import java.io.File;
import java.net.URL;
import java.util.zip.ZipFile;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ZipHelperTest {
    private static File tempDir;
    private static ZipFile testArchive;

    @BeforeClass
    public static void beforeClass() throws Exception {
        tempDir = FileSystemHelper.createTempDir((String)"ArchiveHelperTest");
        URL testArchiveUrl = ZipHelperTest.class.getClassLoader().getResource("test.zip");
        testArchive = new ZipFile(new File(testArchiveUrl.toURI()));
    }

    @After
    public void after() throws Exception {
        FileSystemHelper.cleanDirectory((File)tempDir);
    }

    @Test
    public void testExtractAllEntriesFromArchive() throws Exception {
        ZipHelper.extractEntriesFromArchive((ZipFile)testArchive, (String)"", (File)tempDir);
        Assert.assertTrue((boolean)new File(tempDir, "test/file1.txt").exists());
        Assert.assertTrue((boolean)new File(tempDir, "test/file2.txt").exists());
        Assert.assertTrue((boolean)new File(tempDir, "test/3file.txt").exists());
        Assert.assertTrue((boolean)new File(tempDir, "test/emptyDir/anotherEmptyDir1").exists());
        Assert.assertTrue((boolean)new File(tempDir, "test/emptyDir/anotherEmptyDir2").exists());
    }

    @Test
    public void testExtractOnlyAnEntryFromArchive() throws Exception {
        ZipHelper.extractEntriesFromArchive((ZipFile)testArchive, (String)"test/3file.txt", (File)tempDir);
        Assert.assertTrue((!new File(tempDir, "test/file1.txt").exists() ? 1 : 0) != 0);
        Assert.assertTrue((!new File(tempDir, "test/file2.txt").exists() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)new File(tempDir, "test/3file.txt").exists());
        Assert.assertTrue((!new File(tempDir, "test/emptyDir/anotherEmptyDir1").exists() ? 1 : 0) != 0);
        Assert.assertTrue((!new File(tempDir, "test/emptyDir/anotherEmptyDir2").exists() ? 1 : 0) != 0);
    }

    @Test
    public void testExtractEntriesStartingWithEntryNamePrefixFromArchive() throws Exception {
        ZipHelper.extractEntriesFromArchive((ZipFile)testArchive, (String)"test/fi", (File)tempDir);
        Assert.assertTrue((boolean)new File(tempDir, "test/file1.txt").exists());
        Assert.assertTrue((boolean)new File(tempDir, "test/file2.txt").exists());
        Assert.assertTrue((!new File(tempDir, "test/3file.txt").exists() ? 1 : 0) != 0);
        Assert.assertTrue((!new File(tempDir, "test/emptyDir/anotherEmptyDir1").exists() ? 1 : 0) != 0);
        Assert.assertTrue((!new File(tempDir, "test/emptyDir/anotherEmptyDir2").exists() ? 1 : 0) != 0);
    }

    @Test
    public void testExtractEntriesFromArchiveContainingEmptyDir() throws Exception {
        ZipHelper.extractEntriesFromArchive((ZipFile)testArchive, (String)"test/emptyDir", (File)tempDir);
        Assert.assertTrue((!new File(tempDir, "test/file1.txt").exists() ? 1 : 0) != 0);
        Assert.assertTrue((!new File(tempDir, "test/file2.txt").exists() ? 1 : 0) != 0);
        Assert.assertTrue((!new File(tempDir, "test/3file.txt").exists() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)new File(tempDir, "test/emptyDir/anotherEmptyDir1").exists());
        Assert.assertTrue((boolean)new File(tempDir, "test/emptyDir/anotherEmptyDir2").exists());
    }
}

