
package com.ebmwebsourcing.easycommons.lang;

/**
 * 
 * @author "Mathieu CARROLLE - mathieu.carrolle@petalslink.com"
 * 
 */
public class StringHelper {

    /**
     * Return true if the String is null, contains only space character or is
     * empty.
     * 
     * @param s
     *            a string
     * 
     * @return true if the String is null, contains only space character or is
     *         empty, otherwise false
     */
    public static boolean isNullOrEmpty(final String s) {
        return (s == null) || s.trim().equals("");
    }
    
    /**
     * Return an empty {@link String} if <b>obj</b> is null, otherwise
     * return obj.toString().
     * 
     * @param obj
     * @return
     */
    public static String nonNullValue(Object obj) {
        if (obj == null)
            return "";
        return obj.toString();
    }
}
