/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger;

import com.ebmwebsourcing.easycommons.lang.reflect.ReflectionHelper;
import com.ebmwebsourcing.easycommons.logger.LogDataAppender;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogDataFormatter
extends Formatter {
    private static final String LOGDATA_CANONICAL_CLASSNAME = "com.ebmwebsourcing.easycommons.logger.LogData";
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss,SSS 'GMT'Z", Locale.getDefault());
    private final Deque<LogDataAppender> dataAppenders = new LinkedList<LogDataAppender>();
    private String startingDelimiter = " {{";
    private String endingDelimiter = "}}";

    public void setExtraParametersDelimiter(String startingDelimiter, String endingDelimiter) {
        this.startingDelimiter = startingDelimiter;
        this.endingDelimiter = endingDelimiter;
    }

    public final void addLogDataAppender(LogDataAppender logDataAppender) {
        assert (logDataAppender != null);
        this.dataAppenders.add(logDataAppender);
    }

    final LogDataAppender[] getLogDataAppenders() {
        return this.dataAppenders.toArray(new LogDataAppender[this.dataAppenders.size()]);
    }

    protected void formatExtraParameters(StringBuffer outBuffer, Map<String, Object> extraParameters) {
        Iterator<String> extraParametersKeySetIterator = extraParameters.keySet().iterator();
        if (extraParametersKeySetIterator.hasNext() && !this.dataAppenders.isEmpty()) {
            outBuffer.append(this.startingDelimiter);
            block0: while (extraParametersKeySetIterator.hasNext()) {
                String extraParameterKey = extraParametersKeySetIterator.next();
                Iterator<LogDataAppender> itAppender = this.dataAppenders.descendingIterator();
                while (itAppender.hasNext()) {
                    LogDataAppender appender = itAppender.next();
                    if (!appender.canAppend(extraParameters, extraParameterKey)) continue;
                    appender.append(outBuffer, extraParameters, extraParameterKey);
                    if (!extraParametersKeySetIterator.hasNext()) continue block0;
                    outBuffer.append(", ");
                    continue block0;
                }
            }
            outBuffer.append(this.endingDelimiter);
        }
    }

    private boolean isThereLogDataParameter(Object[] logParameters) {
        return logParameters != null && logParameters.length != 0 && logParameters[0] != null && ReflectionHelper.isOrInheritedFrom(logParameters[0].getClass(), (String)LOGDATA_CANONICAL_CLASSNAME);
    }

    protected void populateExtraParameters(LinkedHashMap<String, Object> extraParameters, LogRecord logRecord) {
        Object[] logParameters = logRecord.getParameters();
        if (this.isThereLogDataParameter(logParameters)) {
            extraParameters.putAll((LinkedHashMap)logParameters[0]);
        }
    }

    protected StringBuffer buildPattern(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.format("%s %s [%s] : %s", this.dateFormat.format(record.getMillis()), record.getLevel(), record.getLoggerName(), record.getMessage()));
        return sb;
    }

    @Override
    public String format(LogRecord record) {
        LinkedHashMap<String, Object> extraParameters = new LinkedHashMap<String, Object>();
        this.populateExtraParameters(extraParameters, record);
        StringBuffer sb = this.buildPattern(record);
        this.formatExtraParameters(sb, extraParameters);
        sb.append("\n");
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            record.getThrown().printStackTrace(new PrintWriter(sw));
            sw.flush();
            sb.append(sw.toString());
        }
        return sb.toString();
    }

    @Override
    public synchronized String formatMessage(LogRecord record) {
        Object[] extraParameters = record.getParameters();
        String result = null;
        if (this.isThereLogDataParameter(extraParameters)) {
            Object[] extraParametersWithoutLogData = Arrays.copyOfRange(extraParameters, 1, extraParameters.length);
            record.setParameters(extraParametersWithoutLogData);
            result = super.formatMessage(record);
            record.setParameters(extraParameters);
        } else {
            result = super.formatMessage(record);
        }
        return result;
    }
}

