/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.sca.helper.impl;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.extensions.Controller;
import org.objectweb.fractal.fraclet.types.Step;

@Scope(value="COMPOSITE")
@Service(value={SCAComponent.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public abstract class SCAComponentImpl
implements SCAComponent {
    private static Logger log = Logger.getLogger(SCAComponentImpl.class.getName());
    @Controller
    private Component component = null;
    private Map<String, Object> context = new HashMap<String, Object>();

    @Lifecycle(step=Step.CREATE)
    public void createSCAComponent() throws SCAException {
        log.fine("Fractal component created: " + SCAHelper.getSCAHelper().getName(this.getComponent()));
    }

    @Lifecycle(step=Step.START)
    public void startSCAComponent() throws SCAException {
        log.fine("Fractal component started: " + SCAHelper.getSCAHelper().getName(this.getComponent()));
    }

    @Lifecycle(step=Step.STOP)
    public void stopSCAComponent() throws SCAException {
        log.fine("Fractal component stopped: " + SCAHelper.getSCAHelper().getName(this.getComponent()));
    }

    @Lifecycle(step=Step.DESTROY)
    public void destroySCAComponent() throws SCAException {
        log.fine("Fractal component destroyed: " + SCAHelper.getSCAHelper().getName(this.getComponent()));
    }

    public Component getComponent() {
        return this.component;
    }

    public String getName() {
        String name = null;
        try {
            name = SCAHelper.getSCAHelper().getName(this.getComponent());
        }
        catch (SCAException sCAException) {
            // empty catch block
        }
        return name;
    }

    public void setName(String name) {
        try {
            SCAHelper.getSCAHelper().changeName(this.getComponent(), name);
        }
        catch (SCAException sCAException) {
            // empty catch block
        }
    }

    public Map<String, Object> getInitializationContext() throws SCAException {
        return this.context;
    }

    public void setInitializationContext(Map<String, Object> context) throws SCAException {
        this.context = context;
    }
}

