/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.sca.helper.util;

import java.io.PrintStream;

public class Console {
    private static Console console;
    private PrintStream ps;
    private String[] expected;
    private int ei = 0;
    private int ej = 0;
    private int line = 1;
    private int col = 1;

    public static void init(PrintStream ps, String[] expected) {
        console = new Console(ps, expected);
    }

    public static Console get() throws IllegalStateException {
        if (console == null) {
            String msg = "Console has not been initialized";
            throw new IllegalStateException(msg);
        }
        return console;
    }

    private Console(PrintStream ps, String[] expected) {
        this.ps = ps;
        this.expected = expected;
    }

    public void println(String s) {
        this.print(s);
        this.print('\n');
    }

    public void print(String s) {
        for (int i = 0; i < s.length(); ++i) {
            this.print(s.charAt(i));
        }
    }

    public void print(char c) {
        if (c == '\n') {
            ++this.line;
            this.col = 1;
        } else {
            char e;
            if (this.ei >= this.expected.length) {
                this.fail();
            }
            if (c != (e = this.expected[this.ei].charAt(this.ej))) {
                this.fail();
            }
            ++this.ej;
            if (this.ej >= this.expected[this.ei].length()) {
                ++this.ei;
                this.ej = 0;
            }
            ++this.col;
        }
        this.ps.print(c);
    }

    private void fail() throws IllegalArgumentException {
        this.ps.println();
        this.ps.println();
        this.ps.println("Expected output is: ");
        for (String expect : this.expected) {
            this.ps.println(expect);
        }
        String msg = "Unexpected character at line " + this.line + ", column " + this.col;
        throw new IllegalArgumentException(msg);
    }
}

