/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.stream;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.stream.InputStreamForker;
import com.ebmwebsourcing.easycommons.thread.TestThread;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.SequenceInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.junit.Assert;
import org.junit.Test;

public class InputStreamForkerTest {
    private static final String DATA = "TEST";
    private static final int[] TEST_STREAM_LENGTHES = new int[]{0, 1, 2, 3, 8, 64, 256, 1024, 8192, 65536};
    private static final String XML_SHEET = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><source><title>XSL</title><author>John Smith</author></source>";

    private static final byte[] getTestData(int len) {
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)i;
        }
        return bytes;
    }

    @Test
    public void testReadInputStreams() throws IOException {
        for (int i : TEST_STREAM_LENGTHES) {
            byte[] testData = InputStreamForkerTest.getTestData(i);
            ByteArrayInputStream is = new ByteArrayInputStream(testData);
            InputStreamForker f = new InputStreamForker((InputStream)is);
            InputStream is1 = f.fork();
            InputStream is2 = f.fork();
            String s1 = this.readStreamInString(is1);
            String s2 = this.readStreamInString(is2);
            Assert.assertEquals((Object)s1, (Object)s2);
        }
    }

    @Test
    public void testReadInputStreamsWithManyThreads() throws Exception {
        int nbThreads = 10;
        TestThread[] testThreads = new TestThread[TEST_STREAM_LENGTHES.length * nbThreads];
        final CyclicBarrier barrier = new CyclicBarrier(nbThreads);
        for (int k = 0; k < TEST_STREAM_LENGTHES.length; ++k) {
            int len = TEST_STREAM_LENGTHES[k];
            final byte[] testData = InputStreamForkerTest.getTestData(len);
            ByteArrayInputStream is = new ByteArrayInputStream(testData);
            final InputStreamForker f = new InputStreamForker((InputStream)is);
            for (int i = 0; i < nbThreads; ++i) {
                TestThread tt;
                testThreads[k * nbThreads + i] = tt = new TestThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            barrier.await();
                            for (int j = 0; j < 10; ++j) {
                                InputStream is = f.fork();
                                byte[] s = InputStreamForkerTest.this.readStream(is);
                                Assert.assertTrue((boolean)Arrays.equals(s, testData));
                            }
                        }
                        catch (InterruptedException ie) {
                            throw new UncheckedException((Throwable)ie);
                        }
                        catch (BrokenBarrierException bbe) {
                            throw new UncheckedException((Throwable)bbe);
                        }
                        catch (IOException io) {
                            throw new UncheckedException((Throwable)io);
                        }
                    }
                });
                tt.start();
            }
        }
        for (int l = 0; l < TEST_STREAM_LENGTHES.length * nbThreads; ++l) {
            testThreads[l].joinExplosively();
        }
    }

    @Test
    public void testAvailable() throws IOException {
        for (int k : TEST_STREAM_LENGTHES) {
            byte[] testData = InputStreamForkerTest.getTestData(k);
            ByteArrayInputStream is = new ByteArrayInputStream(testData);
            InputStreamForker f = new InputStreamForker((InputStream)is);
            InputStream is1 = f.fork();
            InputStream is2 = f.fork();
            Assert.assertTrue((String)"Input stream must be available", (is1.available() >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Input stream must be available", (is1.available() <= k ? 1 : 0) != 0);
            Assert.assertTrue((String)"Input stream must be available", (is2.available() >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Input stream must be available", (is2.available() <= k ? 1 : 0) != 0);
        }
    }

    @Test
    public void testClose() throws IOException {
        for (int k : TEST_STREAM_LENGTHES) {
            byte[] testData = InputStreamForkerTest.getTestData(k);
            ByteArrayInputStream is = new ByteArrayInputStream(testData);
            InputStreamForker f = new InputStreamForker((InputStream)is);
            InputStream is1 = f.fork();
            InputStream is2 = f.fork();
            int closedIS = 0;
            is1.close();
            is2.close();
            try {
                is1.read();
            }
            catch (IOException e) {
                ++closedIS;
            }
            try {
                is2.read();
            }
            catch (IOException e) {
                ++closedIS;
            }
            Assert.assertTrue((String)"Two input stream must be closed", (closedIS != 2 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMarkSupported() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(DATA.getBytes());
        InputStreamForker f = new InputStreamForker((InputStream)is);
        InputStream is1 = f.fork();
        InputStream is2 = f.fork();
        Assert.assertTrue((String)"Mark must be supported", (boolean)is1.markSupported());
        Assert.assertTrue((String)"Mark must be supported", (boolean)is2.markSupported());
    }

    @Test
    public void testRead() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(DATA.getBytes());
        InputStreamForker f = new InputStreamForker((InputStream)is);
        InputStream is1 = f.fork();
        InputStream is2 = f.fork();
        Assert.assertTrue((String)"Impossible to read data from input stream", (is1.read() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Impossible to read data from input stream", (is2.read() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReadByteByteArray() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(DATA.getBytes());
        InputStreamForker f = new InputStreamForker((InputStream)is);
        InputStream is1 = f.fork();
        InputStream is2 = f.fork();
        byte[] buffer1 = new byte[32];
        byte[] buffer2 = new byte[32];
        Assert.assertTrue((String)"Impossible to read data from input stream", (is1.read(buffer1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Impossible to read data from input stream", (is2.read(buffer2) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReadByteArrayAtIndex() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(DATA.getBytes());
        InputStreamForker f = new InputStreamForker((InputStream)is);
        InputStream is1 = f.fork();
        InputStream is2 = f.fork();
        byte[] buffer1 = new byte[32];
        byte[] buffer2 = new byte[32];
        Assert.assertTrue((String)"Impossible to read data from input stream", (is1.read(buffer1, 0, 1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Impossible to read data from input stream", (is2.read(buffer2, 2, 3) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReadPartial() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(DATA.getBytes());
        InputStreamForker f = new InputStreamForker((InputStream)is);
        InputStream is1 = f.fork();
        InputStream is2 = f.fork();
        byte[] firstBuffer = new byte[2];
        byte[] secondBuffer = new byte[3];
        byte[] thirdBuffer = new byte[1];
        Assert.assertEquals((long)2L, (long)is1.read(firstBuffer));
        Assert.assertEquals((long)3L, (long)is2.read(secondBuffer));
        Assert.assertEquals((long)2L, (long)is1.available());
        Assert.assertEquals((long)1L, (long)is2.available());
        Assert.assertEquals((long)2L, (long)is1.read(firstBuffer));
        Assert.assertEquals((long)1L, (long)is2.read(thirdBuffer));
        Assert.assertEquals((long)0L, (long)is1.available());
        Assert.assertEquals((long)0L, (long)is2.available());
    }

    @Test
    public void testReadTotality() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(DATA.getBytes());
        InputStreamForker f = new InputStreamForker((InputStream)is);
        InputStream is1 = f.fork();
        InputStream is2 = f.fork();
        byte[] firstBuffer = new byte[is1.available()];
        byte[] secondBuffer = new byte[is2.available()];
        Assert.assertEquals((long)firstBuffer.length, (long)is1.read(firstBuffer));
        Assert.assertEquals((long)secondBuffer.length, (long)is2.read(secondBuffer));
    }

    @Test
    public void testReset() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(DATA.getBytes());
        InputStreamForker f = new InputStreamForker((InputStream)is);
        InputStream is1 = f.fork();
        InputStream is2 = f.fork();
        is1.reset();
        is2.reset();
    }

    @Test
    public void testSkip() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(DATA.getBytes());
        InputStreamForker f = new InputStreamForker((InputStream)is);
        InputStream is1 = f.fork();
        InputStream is2 = f.fork();
        Assert.assertTrue((String)"Byte not skipped by input stream", (is1.skip(1L) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Byte not skipped by input stream", (is2.skip(2L) > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testClosedOriginalInputStream() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(DATA.getBytes());
        InputStreamForker f = new InputStreamForker((InputStream)is);
        InputStream is1 = f.fork();
        InputStream is2 = f.fork();
        byte[] firstBuffer = new byte[is1.available()];
        byte[] secondBuffer = new byte[is2.available()];
        Assert.assertEquals((long)firstBuffer.length, (long)is1.read(firstBuffer));
        Assert.assertEquals((long)secondBuffer.length, (long)is2.read(secondBuffer));
        ((InputStream)is).close();
        try {
            f.fork();
        }
        catch (IOException e) {
            Assert.fail((String)"Forked input stream creation must be available yet");
        }
    }

    @Test
    public void testConsumedInputStreamBeforeInstantiation() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(DATA.getBytes());
        byte[] firstBuffer = new byte[((InputStream)is).available()];
        Assert.assertEquals((long)firstBuffer.length, (long)is.read(firstBuffer));
        InputStreamForker f = new InputStreamForker((InputStream)is);
        InputStream fis = f.fork();
        byte[] secondBuffer = new byte[fis.available()];
        Assert.assertEquals((String)"Value -1 expected because no more data can be read at the end of the stream", (long)-1L, (long)fis.read(secondBuffer));
    }

    @Test
    public void testTransformFromStreamSource() throws IOException, TransformerException {
        ByteArrayInputStream is = new ByteArrayInputStream(XML_SHEET.getBytes());
        StreamSource ss = new StreamSource(is);
        InputStreamForker f = new InputStreamForker(ss.getInputStream());
        InputStream is1 = f.fork();
        InputStream is2 = f.fork();
        StreamSource xmlSource1 = new StreamSource(is1);
        StreamSource xmlSource2 = new StreamSource(is2);
        StringWriter writer1 = new StringWriter();
        StringWriter writer2 = new StringWriter();
        StreamResult result1 = new StreamResult(writer1);
        StreamResult result2 = new StreamResult(writer2);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(xmlSource1, result1);
        transformer.transform(xmlSource2, result2);
        Assert.assertEquals((Object)XML_SHEET, (Object)writer1.toString());
        Assert.assertEquals((Object)XML_SHEET, (Object)writer2.toString());
    }

    @Test
    public void testBufferedInputStream() throws IOException, SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.inputStreamAbstractorTest(BufferedInputStream.class);
    }

    @Test
    public void testDataInputStream() throws IOException, SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.inputStreamAbstractorTest(DataInputStream.class);
    }

    @Test
    public void testFilterInputStream() throws IOException, SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.inputStreamAbstractorTest(FilterInputStream.class);
    }

    @Test
    public void testSequenceInputStream() throws IOException, SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        SequenceInputStream sis = new SequenceInputStream(new ByteArrayInputStream(DATA.getBytes()), new ByteArrayInputStream(DATA.getBytes()));
        InputStreamForker f = new InputStreamForker((InputStream)sis);
        InputStream is1 = f.fork();
        InputStream is2 = f.fork();
        Assert.assertTrue((String)"Forked input streams must be the same ", (boolean)this.compareInputStream(is1, is2));
    }

    @Test
    public void testPushbackInputStream() throws IOException, SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.inputStreamAbstractorTest(PushbackInputStream.class);
    }

    private byte[] readStream(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int n = 0;
        try {
            while ((n = is.read()) != -1) {
                baos.write(n);
            }
        }
        catch (IOException e) {
            throw new UncheckedException((Throwable)e);
        }
        return baos.toByteArray();
    }

    private String readStreamInString(InputStream is) throws IOException {
        int n;
        assert (is != null);
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((n = reader.read(buffer)) != -1) {
            ((Writer)writer).write(buffer, 0, n);
        }
        return ((Object)writer).toString();
    }

    private boolean compareInputStream(InputStream is1, InputStream is2) throws IOException {
        int result2;
        if (is1.available() != is2.available()) {
            return false;
        }
        byte[] buf1 = new byte[is1.available()];
        byte[] buf2 = new byte[is2.available()];
        int result1 = is1.read(buf1);
        if (result1 != (result2 = is2.read(buf2))) {
            return false;
        }
        for (int i = 0; i < buf1.length; ++i) {
            if (buf1[i] == buf2[i]) continue;
            return false;
        }
        return true;
    }

    private void inputStreamAbstractorTest(Class<? extends InputStream> clazz) throws SecurityException, NoSuchMethodException, IOException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<? extends InputStream> c = clazz.getDeclaredConstructor(InputStream.class);
        c.setAccessible(true);
        InputStream original = c.newInstance(new ByteArrayInputStream(DATA.getBytes()));
        InputStreamForker f = new InputStreamForker(original);
        InputStream is1 = f.fork();
        InputStream is2 = f.fork();
        Assert.assertTrue((String)"Forked input streams must be the same ", (boolean)this.compareInputStream(is1, is2));
    }
}

