/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.stream;

import com.ebmwebsourcing.easycommons.stream.ReaderInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;

public class ReadInputStreamTest
extends TestCase {
    private StringBuffer content;

    protected void setUp() throws Exception {
        super.setUp();
        this.content = new StringBuffer();
        this.content.append("Hi,\n");
        this.content.append("\n");
        this.content.append("My length is 27 bytes.\n");
    }

    public void testAvailableAfterLittleRead() {
        try {
            StringReader reader = new StringReader(this.content.toString());
            ReaderInputStream ris = new ReaderInputStream((Reader)reader);
            byte[] readBuffer = new byte[3];
            ris.read(readBuffer);
            int availableBytes = ris.available();
            ReadInputStreamTest.assertTrue((availableBytes > 0 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            TestCase.fail();
        }
    }

    public void testAvailableAfterAllRead() {
        try {
            StringReader reader = new StringReader(this.content.toString());
            ReaderInputStream ris = new ReaderInputStream((Reader)reader);
            byte[] readBuffer = new byte[1024];
            ris.read(readBuffer);
            int availableBytes = ris.available();
            ReadInputStreamTest.assertTrue((availableBytes == 0 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            TestCase.fail();
        }
    }

    public void testAvailableAfterAllReadPerBlocksLastSmaller() {
        try {
            StringReader reader = new StringReader(this.content.toString());
            ReaderInputStream ris = new ReaderInputStream((Reader)reader);
            this.readPerBlocks((InputStream)ris, 5);
            int availableBytes = ris.available();
            ReadInputStreamTest.assertTrue((availableBytes == 0 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            TestCase.fail();
        }
    }

    public void testReadAll() {
        try {
            StringReader reader = new StringReader(this.content.toString());
            ReaderInputStream ris = new ReaderInputStream((Reader)reader);
            byte[] readBuffer = new byte[1024];
            int readBytes = ris.read(readBuffer);
            ReadInputStreamTest.assertEquals((String)this.content.toString(), (String)new String(readBuffer, 0, readBytes));
        }
        catch (IOException e) {
            e.printStackTrace();
            TestCase.fail();
        }
    }

    public void testReadAllInTwoPasses() {
        try {
            StringReader reader = new StringReader(this.content.toString());
            ReaderInputStream ris = new ReaderInputStream((Reader)reader);
            StringBuffer result = new StringBuffer();
            byte[] readBuffer = new byte[10];
            int readBytes = ris.read(readBuffer);
            ReadInputStreamTest.assertEquals((int)readBuffer.length, (int)readBytes);
            result.append(new String(readBuffer, 0, readBytes));
            readBuffer = new byte[1024];
            readBytes = ris.read(readBuffer);
            result.append(new String(readBuffer, 0, readBytes));
            ReadInputStreamTest.assertEquals((String)this.content.toString(), (String)result.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            TestCase.fail();
        }
    }

    public void testReadAllByOneByte() {
        StringReader reader = new StringReader(this.content.toString());
        ReaderInputStream ris = new ReaderInputStream((Reader)reader);
        this.readPerBlocks((InputStream)ris, 1);
    }

    public void testReadAllBySameBytesBlocks() {
        StringReader reader = new StringReader(this.content.toString());
        ReaderInputStream ris = new ReaderInputStream((Reader)reader);
        this.readPerBlocks((InputStream)ris, 3);
    }

    public void testReadAllByBytesBlocksLastSmaller() {
        StringReader reader = new StringReader(this.content.toString());
        ReaderInputStream ris = new ReaderInputStream((Reader)reader);
        this.readPerBlocks((InputStream)ris, 5);
    }

    private void readPerBlocks(InputStream ris, int blockSize) {
        try {
            StringBuffer result = new StringBuffer();
            byte[] readBuffer = new byte[blockSize];
            int readBytes = 0;
            int charPos = 0;
            while (readBytes != -1) {
                readBytes = ris.read(readBuffer);
                ReadInputStreamTest.assertTrue((charPos >= this.content.length() && readBytes == -1 || charPos < this.content.length() && Math.min(readBuffer.length, this.content.length() - result.length()) == readBytes ? 1 : 0) != 0);
                if (readBytes > 0) {
                    result.append(new String(readBuffer, 0, readBytes));
                }
                charPos += blockSize;
            }
            ReadInputStreamTest.assertEquals((String)this.content.toString(), (String)result.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            TestCase.fail();
        }
    }
}

