package com.ebmwebsourcing.easycommons.fs;

import java.io.File;
import java.io.IOException;
import java.util.Random;

public final class FileSystemHelper {

    private static final Random random = new Random();
    
    private FileSystemHelper() {
    }

    private static final File getSystemTempDir() {
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        assert tmpDirPath != null;
        File tmpDir = new File(tmpDirPath);
        assert tmpDir != null;
        return tmpDir;
    }

    
    public static File createTempDir() throws IOException {
        return createTempDir(getSystemTempDir(), "tmp");
    }
    
    
    public static File createTempDir(String prefix) throws IOException {
        return createTempDir(getSystemTempDir(), prefix);
    }
    
    
    public static File createTempDir(File parentDir, String prefix) throws IOException {
        File tempDir = null;
        while (true) {
            tempDir = new File(parentDir, prefix + random.nextLong());
            if (!tempDir.exists()) break;
        }
        if (!tempDir.mkdir()) {
            throw new IOException(String.format("Impossible to create temp dir '%s'", tempDir.getAbsolutePath()));
        }
        tempDir.deleteOnExit();
        return tempDir;
    }
    
    
}
