package com.ebmwebsourcing.easycommons.io;

import java.io.Closeable;
import java.io.IOException;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;

public class IOHelper {

    private IOHelper() {
    }

    public static void close(Closeable closeable) {
        if (closeable == null)
            return;
        try {
            closeable.close();
        } catch (IOException e) {
            throw new UncheckedException(String.format(
                    "Cannot close object of class '%s'.", closeable.getClass()
                            .getSimpleName()));
        }
    }

}
