/**
 * 
 */

package com.ebmwebsourcing.easycommons.uuid;

import com.eaio.uuid.UUID;

/**
 * @author ofabre
 * 
 */
public class SimpleUUIDGenerator {

    /**
     * <p>
     * Generates an unique identifier. An identifier value has never been
     * returned (existed) before its calculation.
     * </p>
     * 
     * <p>
     * The identifier is composed of one part:
     * <li>an UUID created according to the DCE Universal Token Identifier
     * specification</li>
     * </ol>
     * </p>
     * <p>
     * This method is threadsafe.
     * </p>
     * 
     * @return A unique identifier
     * 
     */
    public String getNewID() {
        return new UUID().toString();
    }

}
