
package com.ebmwebsourcing.easycommons.xml;

import java.io.IOException;
import java.io.StringWriter;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.stream.InputStreamForker;
import com.ebmwebsourcing.easycommons.stream.ReaderInputStream;

/**
 * 
 * @author "Mathieu CARROLLE - mathieu.carrolle@petalslink.com"
 * 
 */
public class SourceHelper {

    private static final Transformer transformer;

    static {
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        } catch (TransformerConfigurationException e) {
            throw new UncheckedException("Failed to create Transformer", e);
        }
    }

    public static String toString(Source source) throws TransformerException {
        final StringWriter writer = new StringWriter();
        final Result result = new StreamResult(writer);
        transformer.transform(source, result);
        return writer.toString();
    }

    private static final Source forkStreamSource(final StreamSource source) throws IOException {
        InputStreamForker streamForker;
        if (source.getInputStream() != null) {
            streamForker = new InputStreamForker(source.getInputStream());
        } else {
            streamForker = new InputStreamForker(new ReaderInputStream(source.getReader()));
        }
        source.setInputStream(streamForker.fork());
        return new StreamSource(streamForker.fork());
    }

    /**
     * Fork, if necessary, a {@link Source} so that consuming the forked one
     * does not consume the original one.
     * 
     * @param source
     *            {@link Source} to be forked.
     * @return Forked {@link Source}.
     * @throws <IOException>
     */
    public static Source fork(Source source) throws IOException {
        if (source instanceof DOMSource) {
            return source;
        } else if (source instanceof StreamSource) {
            return forkStreamSource((StreamSource) source);
        } else {
            throw new IllegalArgumentException(
                    "Only DOMSource or StreamSource are supported right now.");
        }
    }

}
