/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import com.ebmwebsourcing.easycommons.xml.DOMHelper;
import com.ebmwebsourcing.easycommons.xml.SourceHelper;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.junit.Assert;
import org.junit.Test;

public class SourceHelperTest {
    private static final Source[] newTestSources(String xmlMessage) {
        StreamSource streamSource = new StreamSource(new ByteArrayInputStream(xmlMessage.getBytes()));
        DOMSource domSource = DOMHelper.parseAsDOMSource((InputStream)new ByteArrayInputStream(xmlMessage.getBytes()));
        return new Source[]{streamSource, domSource};
    }

    @Test
    public void testSourceToString() throws Exception {
        for (String xmlMessage : new String[]{"<toto></toto>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><toto></toto>"}) {
            for (Source source : SourceHelperTest.newTestSources(xmlMessage)) {
                String sourceAsString = SourceHelper.toString((Source)source);
                Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)xmlMessage, (String)sourceAsString));
            }
        }
    }

    @Test(expected=TransformerException.class)
    public void testMalformedStreamSourceToString() throws Exception {
        String xmlMessage = "<tot";
        ByteArrayInputStream bais = new ByteArrayInputStream(xmlMessage.getBytes());
        StreamSource source = new StreamSource(bais);
        SourceHelper.toString((Source)source);
    }

    @Test
    public void testForkAllowedSources() throws TransformerException, IOException {
        for (String xmlMessage : new String[]{"<toto></toto>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><toto></toto>"}) {
            for (Source source : SourceHelperTest.newTestSources(xmlMessage)) {
                if (source instanceof SAXSource || source instanceof StAXSource) continue;
                Source forkedSource = SourceHelper.fork((Source)source);
                Assert.assertEquals((Object)SourceHelper.toString((Source)source), (Object)SourceHelper.toString((Source)forkedSource));
            }
        }
    }

    @Test
    public void testForkUnallowedSources() throws TransformerException, IOException {
        for (String xmlMessage : new String[]{"<toto></toto>", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><toto></toto>"}) {
            for (Source source : SourceHelperTest.newTestSources(xmlMessage)) {
                if (source instanceof DOMSource || source instanceof StreamSource) continue;
                try {
                    SourceHelper.fork((Source)source);
                }
                catch (IllegalArgumentException iae) {
                    continue;
                }
                Assert.fail();
            }
        }
    }

    public void testForkMalformedStreamSource() throws TransformerException, IOException {
        String xmlMessage = "<tot";
        ByteArrayInputStream bais = new ByteArrayInputStream(xmlMessage.getBytes());
        StreamSource source = new StreamSource(bais);
        Source forkedSource = SourceHelper.fork((Source)source);
        try {
            SourceHelper.toString((Source)source);
        }
        catch (TransformerException te1) {
            try {
                SourceHelper.toString((Source)forkedSource);
            }
            catch (TransformerException te2) {
                return;
            }
        }
        Assert.fail();
    }
}

