/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import com.ebmwebsourcing.easycommons.xml.resolver.JARResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.URIMultipleResolvers;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import junit.framework.Assert;
import org.junit.Test;

public class URIMultipleResolversTest {
    @Test
    public void testAllNull() throws TransformerException {
        Source s = new URIMultipleResolvers().resolve(null, null);
        Assert.assertNull((Object)s);
    }

    @Test
    public void testBaseUriNull() throws TransformerException {
        Assert.assertNull((Object)new URIMultipleResolvers().resolve(null, "test.xml"));
    }

    @Test
    public void testFile() throws TransformerException {
        File f = new File("./src/test/resources");
        Assert.assertNotNull((Object)new URIMultipleResolvers().resolve(f.toURI().toString(), "test.xml"));
    }

    @Test
    public void testJar() throws TransformerException, URISyntaxException {
        URI jar = new URI("jar:" + new File("./src/test/resources/ws-echo.jar").toURI() + "!/wsdl/echo.wsdl");
        Assert.assertEquals((String)"jar", (String)jar.getScheme());
        Assert.assertNotNull((Object)new URIMultipleResolvers().resolve(jar.toString(), null));
    }

    @Test
    public void testSpace() throws URISyntaxException, TransformerException {
        File f = new File("./src/test/resources/petals link/");
        Assert.assertNotNull((Object)new URIMultipleResolvers().resolve(f.toURI().toString(), "test.xml"));
    }

    @Test
    public void addResolver() throws URISyntaxException, TransformerException {
        URIMultipleResolvers r = new URIMultipleResolvers();
        Assert.assertEquals((int)2, (int)r.getURIResolvers().length);
        r.addURIResolver((URIResolver)new JARResolver());
        Assert.assertEquals((int)3, (int)r.getURIResolvers().length);
    }
}

