/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger;

import com.ebmwebsourcing.easycommons.logger.Formatter;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Node;

public class Logger
extends java.util.logging.Logger {
    private String className = null;
    private java.util.logging.Logger internalLog = null;
    private static ConsoleHandler consoleHandler = new ConsoleHandler();
    private static Formatter formatter = new Formatter();

    protected Logger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    private Logger(String className, String name, String resourceBundleName, java.util.logging.Logger javaLog) {
        super(name, resourceBundleName);
        this.className = className;
        this.internalLog = javaLog;
        this.internalLog.setUseParentHandlers(false);
        if (!this.containsConsoleHandler(consoleHandler)) {
            this.internalLog.addHandler(consoleHandler);
        }
    }

    private synchronized boolean containsConsoleHandler(ConsoleHandler consoleHandler) {
        boolean res = false;
        for (Handler h : this.internalLog.getHandlers()) {
            if (h != consoleHandler) continue;
            res = true;
            break;
        }
        return res;
    }

    public static synchronized Logger getLogger(String className) {
        java.util.logging.Logger javaLog = java.util.logging.Logger.getLogger(className);
        return new Logger(className, javaLog.getName(), javaLog.getResourceBundleName(), javaLog);
    }

    private synchronized String createLogString(Object ... msg) {
        String res = "";
        formatter.setClassName(this.className);
        for (Object obj : msg) {
            res = obj instanceof Element ? res + new XMLOutputter(Format.getPrettyFormat()).outputString((Element)obj) : (obj instanceof Document ? res + new XMLOutputter(Format.getPrettyFormat()).outputString((Document)obj) : (obj instanceof Node ? res + XMLPrettyPrinter.prettyPrint((Node)((Node)obj)) : (obj instanceof Object[] ? res + this.invokeReflexiveMethod((Object[])obj) : res + obj)));
        }
        return res;
    }

    private String invokeReflexiveMethod(Object[] objs) {
        String res = null;
        if (objs.length >= 2 && !(objs[0] instanceof String) && objs[1] instanceof String) {
            Object objToCall = objs[0];
            String methodName = (String)objs[1];
            Object[] parameters = this.createParameters(objs);
            Class<?>[] parameterTypes = this.createParametersType(parameters);
            try {
                Method m = this.findMethod(objToCall, methodName, parameterTypes);
                res = m.invoke(objToCall, parameters).toString();
            }
            catch (SecurityException e) {
                res = "Internal Logger Error (SecurityException): " + e.getMessage() + " for print: " + objs;
            }
            catch (NoSuchMethodException e) {
                res = "Internal Logger Error (NoSuchMethodException): " + e.getMessage() + " for print: " + objs;
            }
            catch (IllegalArgumentException e) {
                res = "Internal Logger Error (IllegalArgumentException): " + e.getMessage() + " for print: " + objs;
            }
            catch (IllegalAccessException e) {
                res = "Internal Logger Error (IllegalAccessException): " + e.getMessage() + " for print: " + objs;
            }
            catch (InvocationTargetException e) {
                res = "Internal Logger Error (InvocationTargetException): " + e.getMessage() + " for print: " + objs;
            }
        } else {
            res = objs.toString();
        }
        return res;
    }

    private Method findMethod(Object objToCall, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Method res = null;
        for (Method m : objToCall.getClass().getMethods()) {
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != parameterTypes.length) continue;
            res = m;
            break;
        }
        if (res == null) {
            throw new NoSuchMethodException("Impossible to find method: " + methodName + " in class " + objToCall.getClass());
        }
        return res;
    }

    private Class<?>[] createParametersType(Object[] parameters) {
        Class[] classes = new Class[parameters.length];
        int i = 0;
        for (Object obj : parameters) {
            classes[i] = obj.getClass();
            ++i;
        }
        return classes;
    }

    private Object[] createParameters(Object[] objs) {
        Object[] res = null;
        if (objs.length > 2) {
            res = new Object[objs.length - 2];
            int j = 0;
            for (int i = 2; i < objs.length; ++i) {
                res[j] = objs[i];
                ++j;
            }
        }
        return res;
    }

    public void fine(Object ... msg) {
        if (this.isLoggable(Level.FINE)) {
            String res = this.createLogString(msg);
            this.internalLog.fine(res);
        }
    }

    public void finer(Object ... msg) {
        if (this.isLoggable(Level.FINER)) {
            String res = this.createLogString(msg);
            this.internalLog.finer(res);
        }
    }

    public void finest(Object ... msg) {
        if (this.isLoggable(Level.FINEST)) {
            String res = this.createLogString(msg);
            this.internalLog.finest(res);
        }
    }

    public void info(Object ... msg) {
        if (this.isLoggable(Level.INFO)) {
            String res = this.createLogString(msg);
            this.internalLog.info(res);
        }
    }

    public void severe(Object ... msg) {
        if (this.isLoggable(Level.SEVERE)) {
            String res = this.createLogString(msg);
            this.internalLog.severe(res);
        }
    }

    public void warning(Object ... msg) {
        if (this.isLoggable(Level.WARNING)) {
            String res = this.createLogString(msg);
            this.internalLog.warning(res);
        }
    }

    @Override
    public void fine(String msg) {
        if (this.isLoggable(Level.FINE)) {
            Object[] args = new Object[]{msg};
            this.fine(args);
        }
    }

    @Override
    public void finer(String msg) {
        if (this.isLoggable(Level.FINER)) {
            Object[] args = new Object[]{msg};
            this.finer(args);
        }
    }

    @Override
    public void finest(String msg) {
        if (this.isLoggable(Level.FINEST)) {
            Object[] args = new Object[]{msg};
            this.finest(args);
        }
    }

    @Override
    public void info(String msg) {
        if (this.isLoggable(Level.INFO)) {
            Object[] args = new Object[]{msg};
            this.info(args);
        }
    }

    @Override
    public void severe(String msg) {
        if (this.isLoggable(Level.SEVERE)) {
            Object[] args = new Object[]{msg};
            this.severe(args);
        }
    }

    @Override
    public void warning(String msg) {
        if (this.isLoggable(Level.WARNING)) {
            Object[] args = new Object[]{msg};
            this.warning(args);
        }
    }

    public java.util.logging.Logger getInternalLog() {
        return this.internalLog;
    }

    static {
        consoleHandler.setFormatter(formatter);
    }
}

