package com.ebmwebsourcing.easycommons.logger;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class LogManager extends java.util.logging.LogManager {

	public LogManager() {
		super();
	}

	@Override
	public void readConfiguration() throws IOException, SecurityException {
		try {
			String configurationResourcePath = System
					.getProperty("easycommons-logging.config.file");
			InputStream is = null;
			if (configurationResourcePath != null) {
				getClass().getClassLoader().getResourceAsStream(
						configurationResourcePath);
			}
			if (is == null) {
				is = getClass().getClassLoader().getResourceAsStream(
						"easycommons-logging.properties");
				assert is != null;
			}
			super.readConfiguration(is);
		} catch (Exception e) {
			e.printStackTrace(System.err);
		}
	}

	@Override
	public synchronized Logger getLogger(String name) {
		if (name.isEmpty())
			return super.getLogger(name);
		Logger result = super.getLogger(name);
		if (result == null) {
			result = new com.ebmwebsourcing.easycommons.logger.Logger(name,
					null);
			addLogger(result);
			result = getLogger(name);
		}
		return result;
	}

}
