package com.ebmwebsourcing.easycommons.logger;

import java.util.logging.LogRecord;

public class Logger extends java.util.logging.Logger {

	Logger(String name, String resourceBundleName) {
		super(name, resourceBundleName);
	}

	@Override
	public void log(LogRecord record) {
		inferCaller(record);
		super.log(record);
	}

	/**
	 * Copied and pasted from JDK, and adapted to suit our needs.
	 * 
	 * @param record
	 */
	private void inferCaller(LogRecord record) {
		StackTraceElement stack[] = (new Throwable()).getStackTrace();
		int ix = 0;
		boolean firstJavaLoggerFound = false;
		while (ix < stack.length) {
			StackTraceElement frame = stack[ix];
			String cname = frame.getClassName();
			if (cname.equals(java.util.logging.Logger.class.getName())) {
				firstJavaLoggerFound = true;
			} else if (firstJavaLoggerFound) {
				break;
			}
			ix++;
		}

		while (ix < stack.length) {
			StackTraceElement frame = stack[ix];
			String cname = frame.getClassName();
			if (!cname.equals(Logger.class.getName())) {
				// We've found the relevant frame.
				record.setSourceClassName(cname);
				record.setSourceMethodName(frame.getMethodName());
				return;
			}
			ix++;
		}
	}
}
