package org.petalslink.abslayer.service.impl.wsdl11;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;

import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;

public class InterfaceImpl implements Interface {

    private final PortType model;

    private QName qname;

    private InterfaceImpl(PortType model) {
        assert model != null;
        this.model = model;
    }

    @Override
    public QName getQName() {
        if (qname == null) {
            qname = new QName(getParentDescription().getTargetNamespace(),
                    model.getName());
        }
        return qname;
    }

    @Override
    public Description getParentDescription() {
        Definitions definitions = (Definitions) model.getXmlObjectBaseRoot();
        if (definitions == null)
            return null;
        return (org.petalslink.abslayer.service.api.Description) Factory.getInstance().wrap(definitions);
    }

    @Override
    public Operation getOperation(QName qname) {
        com.ebmwebsourcing.easywsdl11.api.element.Operation op = model
                .getOperationByName(qname.getLocalPart());
        if (op == null)
            return null;
        return (org.petalslink.abslayer.service.api.Operation) Factory.getInstance().wrap(op);
    }
    
    @Override
	public Operation[] getOperations() {
		List<Operation> ops = new ArrayList<Operation>();
		com.ebmwebsourcing.easywsdl11.api.element.Operation[] operations = model.getOperations();
		for(com.ebmwebsourcing.easywsdl11.api.element.Operation op: operations) {
			ops.add((org.petalslink.abslayer.service.api.Operation) Factory.getInstance().wrap(op));
		}
		return ops.toArray(new Operation[ops.size()]);
	}
    
    @Override
    public PortType getModel(){
    	return model;
    }
	
}
