package org.petalslink.abslayer.service.impl.wsdl11;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;

public class ServiceImpl implements org.petalslink.abslayer.service.api.Service {

    private final com.ebmwebsourcing.easywsdl11.api.element.Service model;

    private ServiceImpl(com.ebmwebsourcing.easywsdl11.api.element.Service model) {
        this.model = model;
    }

    @Override
    public QName getQName() {
        return model.inferQName();
    }

    @Override
    public Endpoint getEndpoint(String s) {
        Port port = model.getPortByName(s);
        if (port == null)
            return null;
        return (org.petalslink.abslayer.service.api.Endpoint) Factory.getInstance().wrap(port);
    }

	@Override
	public Endpoint[] getEndpoints() {
		List<Endpoint> eps = new ArrayList<Endpoint>();
		Port[] ports = model.getPorts();
		for(Port port: ports) {
			eps.add((org.petalslink.abslayer.service.api.Endpoint) Factory.getInstance().wrap(port));
		}
		return eps.toArray(new Endpoint[eps.size()]);
	}

	@Override
	public Description getDescription() {
		Definitions desc = (Definitions) model.getXmlObjectParent();
        if (desc == null)
            return null;
        return (Description) Factory.getInstance().wrap(desc);

	}

}
