/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easytools.plugin.release.impl;

import com.ebmwebsourcing.easytools.plugin.release.impl.Dependency;
import com.ebmwebsourcing.easytools.plugin.release.impl.TreeMojo;
import com.ebmwebsourcing.easytools.plugin.release.impl.util.FileUtil;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class CleanMojo
extends AbstractMojo {
    private static Logger log = Logger.getLogger(CleanMojo.class.getName());
    protected String version = null;
    private MavenProject project = null;
    private TreeMojo tree = new TreeMojo();

    public void setBaseDir(URI baseDir) {
        this.tree.setBaseDir(baseDir);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void execute() throws MojoExecutionException {
        try {
            if (this.project != null) {
                this.tree.setProject(this.getProject());
                this.tree.validBaseDir();
                System.out.println("start tree on projet: " + this.project.getArtifactId());
                MavenProject effectiveProject = this.project;
                ArrayList<Dependency> allDependencies = new ArrayList<Dependency>();
                allDependencies.addAll(this.tree.getAllDependencies(effectiveProject));
                allDependencies.add(new Dependency(URI.create(this.tree.getBaseDir().toString() + "/pom.xml")));
                this.deleteVersioningPom(allDependencies);
                this.deleteDonePom(allDependencies);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public void deleteVersioningPom(List<Dependency> allDependencies) throws Exception {
        for (Dependency dep : allDependencies) {
            List<File> releasedpoms = this.findReleasedPoms(dep.getLocation());
            for (File f : releasedpoms) {
                if (!f.exists() || f.delete()) continue;
                System.err.println("Impossible to delete: " + f);
            }
        }
    }

    private List<File> findReleasedPoms(URI location) throws Exception {
        ArrayList<File> releasedPoms = new ArrayList<File>();
        File dirPom = new File(location).getParentFile();
        if (dirPom.isDirectory()) {
            for (File f : FileUtil.getAllFiles(dirPom)) {
                if (!f.isFile() || !f.toString().contains("\\pom") || !f.toString().endsWith(".xml") || f.toString().endsWith("\\pom.xml")) continue;
                releasedPoms.add(f);
                break;
            }
        }
        return releasedPoms;
    }

    public void deleteDonePom(List<Dependency> allDependencies) {
        for (Dependency dep : allDependencies) {
            File f = new File(URI.create(dep.getLocation().toString().replace("pom.xml", "done")));
            if (!f.exists() || f.delete()) continue;
            System.err.println("Impossible to delete: " + f);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

