/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easytools.plugin.release.impl;

import com.ebmwebsourcing.easytools.plugin.release.impl.TreeMojo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;

public class Dependency {
    private String groupId;
    private String artifactId;
    private String version;
    private Parent parent;
    private boolean testIsRequired = false;
    private boolean isDistrib = false;
    private MavenXpp3Reader reader = new MavenXpp3Reader();
    private MavenXpp3Writer writer = new MavenXpp3Writer();
    private URI location;
    private MavenProject projectModel;
    private List<Dependency> childDependencies = null;

    public Dependency(org.apache.maven.model.Dependency dependence, URI location) throws Exception {
        this.groupId = dependence.getGroupId();
        this.artifactId = dependence.getArtifactId();
        this.version = dependence.getVersion();
        this.location = location;
        FileInputStream is = new FileInputStream(new File(location));
        Model dependenceModel = this.reader.read((InputStream)is);
        ((InputStream)is).close();
        this.parent = dependenceModel.getParent();
        this.projectModel = new MavenProject(dependenceModel);
    }

    public Dependency(URI location) throws Exception {
        FileInputStream is = new FileInputStream(new File(location));
        Model dependenceModel = this.reader.read((InputStream)is);
        ((InputStream)is).close();
        this.location = location;
        this.projectModel = new MavenProject(dependenceModel);
        this.groupId = this.projectModel.getGroupId();
        this.artifactId = this.projectModel.getArtifactId();
        this.version = this.projectModel.getVersion();
        this.parent = dependenceModel.getParent();
    }

    public Dependency(Parent parent, URI location) throws Exception {
        this.groupId = parent.getGroupId();
        this.artifactId = parent.getArtifactId();
        this.version = parent.getVersion();
        this.location = location;
        FileInputStream is = new FileInputStream(new File(location));
        Model dependenceModel = this.reader.read((InputStream)is);
        ((InputStream)is).close();
        this.parent = dependenceModel.getParent();
        this.projectModel = new MavenProject(dependenceModel);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public URI getLocation() {
        return this.location;
    }

    public MavenProject getProjectModel() {
        return this.projectModel;
    }

    public Parent getParent() {
        return this.parent;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dependency other = (Dependency)obj;
        if (this.getGroupId() == null ? other.getGroupId() != null : !this.getGroupId().equals(other.getGroupId())) {
            return false;
        }
        if (this.getArtifactId() == null ? other.getArtifactId() != null : !this.getArtifactId().equals(other.getArtifactId())) {
            return false;
        }
        return !(this.getVersion() == null ? other.getVersion() != null : !this.getVersion().equals(other.getVersion()));
    }

    public String toString() {
        return this.groupId + ":" + this.getArtifactId();
    }

    public void write(URI uri) throws IOException {
        System.out.println("write " + uri);
        File f = new File(uri);
        FileWriter writer = new FileWriter(f);
        this.writer.write((Writer)writer, this.getProjectModel().getModel());
        writer.close();
    }

    public Type getType() {
        if ("jar".equals(this.getProjectModel().getPackaging())) {
            return Type.JAR;
        }
        if ("maven-plugin".equals(this.getProjectModel().getPackaging())) {
            return Type.JAR;
        }
        if ("pom".equals(this.getProjectModel().getPackaging())) {
            return Type.POM;
        }
        return null;
    }

    public boolean isTestIsRequired() {
        return this.testIsRequired;
    }

    public void setTestIsRequired(boolean testIsRequired) {
        this.testIsRequired = testIsRequired;
    }

    public boolean isDistrib() {
        return this.isDistrib;
    }

    public void setDistrib(boolean isDistrib) {
        this.isDistrib = isDistrib;
    }

    public List<Dependency> getChildDependencies() throws Exception {
        if (this.childDependencies == null) {
            TreeMojo treeMojo = new TreeMojo();
            treeMojo.setProject(this.projectModel);
            treeMojo.setBaseDir(this.location);
            this.childDependencies = treeMojo.getAllDependencies(this.projectModel);
        }
        return this.childDependencies;
    }

    public static enum Type {
        JAR,
        POM;

    }
}

