/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easytools.plugin.release.impl;

import com.ebmwebsourcing.easytools.plugin.release.impl.Dependency;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.model.Parent;

public class DependencyComparator
implements Comparator<Dependency> {
    List<Dependency> deps = null;

    public DependencyComparator(List<Dependency> deps) {
        this.deps = deps;
    }

    @Override
    public int compare(Dependency d1, Dependency d2) {
        if (d1.getType() == Dependency.Type.POM && d2.getType() == Dependency.Type.POM) {
            int d1Parent = this.getNumberOfParent(d1);
            int d2Parent = this.getNumberOfParent(d2);
            System.out.println("Compare: d1Parent = " + d1Parent + " - d2Parent = " + d2Parent);
            if (d1Parent > d2Parent) {
                return 1;
            }
            return -1;
        }
        if (d1.getType() == Dependency.Type.JAR && d2.getType() == Dependency.Type.JAR) {
            System.out.println("Compare: " + d1.getArtifactId() + " with " + d2.getArtifactId() + ": ");
            if (this.d2IsInDependenciesOfd1(d1, d2)) {
                System.out.println(" 1");
                return 1;
            }
            System.out.println(" -1");
            return -1;
        }
        System.out.println("BUG: d1 = " + (Object)((Object)d1.getType()) + " - d2 = " + (Object)((Object)d2.getType()));
        return 0;
    }

    public boolean d2IsInDependenciesOfd1(Dependency d1, Dependency d2) {
        for (org.apache.maven.model.Dependency d : d1.getProjectModel().getDependencies()) {
            if (!d.getGroupId().equals(d2.getGroupId()) || !d.getArtifactId().equals(d2.getArtifactId())) continue;
            return true;
        }
        ArrayList<Dependency> parents = new ArrayList<Dependency>();
        Dependency parent = this.findDependency(d1.getParent(), d1);
        while (parent != null) {
            parents.add(parent);
            parent = this.findDependency(parent.getParent(), parent);
        }
        for (Dependency dP : parents) {
            for (org.apache.maven.model.Dependency d : dP.getProjectModel().getDependencies()) {
                if (!d.getGroupId().equals(d2.getGroupId()) || !d.getArtifactId().equals(d2.getArtifactId())) continue;
                return true;
            }
        }
        try {
            for (Dependency d : d1.getChildDependencies()) {
                if (!d.getGroupId().equals(d2.getGroupId()) || !d.getArtifactId().equals(d2.getArtifactId())) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public int getNumberOfParent(Dependency d1) {
        int res = 0;
        Parent p = d1.getParent();
        while (p != null) {
            ++res;
            Dependency currentD = this.findDependency(p, d1);
            p = currentD.getParent();
        }
        return res;
    }

    private Dependency findDependency(Parent p, Dependency child) {
        if (p != null) {
            for (Dependency d : this.deps) {
                if (d.getGroupId().equals(p.getGroupId()) && d.getArtifactId().equals(p.getArtifactId()) && d.getVersion().equals(p.getVersion())) {
                    return d;
                }
                if (!d.getGroupId().equals(p.getGroupId()) || !d.getArtifactId().equals(p.getArtifactId()) || d.getVersion().equals(p.getVersion())) continue;
                System.out.println("WARNING!!!!!!!!!!!!!!! not same version defined: " + p.getArtifactId() + ":" + p.getGroupId() + " => version is " + p.getVersion() + " or " + d.getVersion());
                System.out.println("See child: " + child.getArtifactId() + ":" + child.getGroupId());
            }
        }
        return null;
    }
}

