/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easytools.plugin.release.impl;

import com.ebmwebsourcing.easytools.plugin.release.impl.Dependency;
import com.ebmwebsourcing.easytools.plugin.release.impl.ReleaseMojo;
import com.ebmwebsourcing.easytools.plugin.release.impl.util.URIHelper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class TreeMojo
extends AbstractMojo {
    private static Logger log = Logger.getLogger(TreeMojo.class.getName());
    private MavenProject project = null;
    private URI baseDir = null;
    private static List<URI> referenceDirs = new ArrayList<URI>();
    private List<String> propertyTagContainingSnapshotVersion = null;
    private List<org.apache.maven.model.Dependency> dependenciesToExclude = new ArrayList<org.apache.maven.model.Dependency>();

    public List<org.apache.maven.model.Dependency> getDependenciesToExclude() {
        return this.dependenciesToExclude;
    }

    public List<String> getPropertyTagContainingSnapshotVersion() {
        return this.propertyTagContainingSnapshotVersion;
    }

    public void setPropertyTagContainingSnapshotVersion(List<String> propertyTagContainingSnapshotVersion) {
        this.propertyTagContainingSnapshotVersion = propertyTagContainingSnapshotVersion;
    }

    public static List<URI> getReferenceDirs() {
        return referenceDirs;
    }

    public URI getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(URI baseDir) {
        this.baseDir = baseDir;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void execute() throws MojoExecutionException {
        try {
            if (this.project != null) {
                this.validBaseDir();
                System.out.println("start tree on projet: " + this.project.getArtifactId());
                MavenProject effectiveProject = this.project;
                this.getAllDependencies(effectiveProject);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public List<Dependency> getAllDependencies(MavenProject effectiveProject) throws Exception {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        ArrayList<Dependency> childDependencies = new ArrayList<Dependency>();
        ArrayList<Dependency> parentDependencies = new ArrayList<Dependency>();
        this.getAllInternalSnapshotParentDependencies(effectiveProject.getModel().getParent(), parentDependencies, 0);
        this.propertyTagContainingSnapshotVersion = TreeMojo.getPropertyTagContainingVersion(parentDependencies);
        this.getAllInternalSnapshotChildInDependencies(effectiveProject, childDependencies, 0);
        for (Dependency dependence : childDependencies) {
            this.getAllInternalSnapshotParentDependencies(dependence.getParent(), parentDependencies, 0);
        }
        this.getAllInternalSnapshotChildInParentDependencies(effectiveProject, parentDependencies, childDependencies, 0);
        this.propertyTagContainingSnapshotVersion = TreeMojo.getPropertyTagContainingVersion(parentDependencies);
        for (Dependency dependence : parentDependencies) {
            System.out.println(dependence);
        }
        deps.addAll(childDependencies);
        deps.addAll(parentDependencies);
        return deps;
    }

    public static List<String> getPropertyTagContainingVersion(List<Dependency> parentDependencies) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Dependency dep : parentDependencies) {
            if (dep.getProjectModel().getProperties() == null) continue;
            for (Map.Entry<Object, Object> entry : dep.getProjectModel().getProperties().entrySet()) {
                String version;
                if (!(entry.getValue() instanceof String) || (version = (String)entry.getValue()) == null || !version.contains("SNAPSHOT")) continue;
                keys.add((String)entry.getKey());
            }
        }
        return keys;
    }

    public Dependency findDependency(org.apache.maven.model.Dependency d, List<Dependency> allDependencies) {
        if (d != null) {
            for (Dependency d1 : allDependencies) {
                if (!d1.getGroupId().equals(d.getGroupId()) || !d1.getArtifactId().equals(d.getArtifactId()) || !d1.getVersion().equals(d.getVersion())) continue;
                return d1;
            }
        }
        return null;
    }

    public void validBaseDir() throws MojoExecutionException {
        try {
            URI bootstrapReferenceDir;
            URI productReferenceDir;
            URI researchReferenceDir;
            URI bootstrapReferenceDir2;
            referenceDirs.clear();
            if (this.baseDir == null) {
                this.baseDir = new File(".").toURI();
            }
            if (!(this.baseDir.toString().contains("research/dev/") || this.baseDir.toString().contains("research/commons/") || this.baseDir.toString().contains("research/projects/"))) {
                throw new MojoExecutionException("This release plugin can work only if it used in continuous integration repository (dev repo) or in research/commons or projects !!!");
            }
            if (this.baseDir.toString().contains("/product/dev/")) {
                URI productReferenceDir2 = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/product/dev/") + "/product/dev/".length()));
                referenceDirs.add(URIHelper.resolve(productReferenceDir2, ReleaseMojo.ReferenceTag.STABLE.toString()));
                referenceDirs.add(URIHelper.resolve(productReferenceDir2, ReleaseMojo.ReferenceTag.PROD.toString()));
                referenceDirs.add(URIHelper.resolve(productReferenceDir2, ReleaseMojo.ReferenceTag.COOKING.toString()));
                URI researchReferenceDir2 = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/product/dev/")) + "/research/dev/");
                referenceDirs.add(URIHelper.resolve(researchReferenceDir2, ReleaseMojo.ReferenceTag.EXPERIMENTAL.toString()));
                bootstrapReferenceDir2 = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/product/dev/")) + "/product/");
                referenceDirs.add(URIHelper.resolve(bootstrapReferenceDir2, ReleaseMojo.ReferenceTag.BOOTSTRAP.toString()));
            }
            if (this.baseDir.toString().contains("/research/dev/")) {
                URI researchReferenceDir3 = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/research/dev/") + "/research/dev/".length()));
                referenceDirs.add(URIHelper.resolve(researchReferenceDir3, ReleaseMojo.ReferenceTag.EXPERIMENTAL.toString()));
                URI productReferenceDir3 = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/research/dev/")) + "/product/dev/");
                referenceDirs.add(URIHelper.resolve(productReferenceDir3, ReleaseMojo.ReferenceTag.STABLE.toString()));
                referenceDirs.add(URIHelper.resolve(productReferenceDir3, ReleaseMojo.ReferenceTag.COOKING.toString()));
                referenceDirs.add(URIHelper.resolve(productReferenceDir3, ReleaseMojo.ReferenceTag.PROD.toString()));
                bootstrapReferenceDir2 = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/research/dev/")) + "/product/");
                referenceDirs.add(URIHelper.resolve(bootstrapReferenceDir2, ReleaseMojo.ReferenceTag.BOOTSTRAP.toString()));
                URI commonsResearchReferenceDir = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/research/dev/")) + "/research/");
                referenceDirs.add(URIHelper.resolve(commonsResearchReferenceDir, ReleaseMojo.ReferenceTag.COMMONS.toString()));
                URI projectsResearchReferenceDir = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/research/dev/")) + "/research/");
                referenceDirs.add(URIHelper.resolve(projectsResearchReferenceDir, ReleaseMojo.ReferenceTag.PROJECTS.toString()));
            }
            if (this.baseDir.toString().contains("/research/commons/")) {
                URI commonsResearchReferenceDir = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/research/commons/") + "/research/".length()));
                referenceDirs.add(URIHelper.resolve(commonsResearchReferenceDir, ReleaseMojo.ReferenceTag.COMMONS.toString()));
                URI projectsResearchReferenceDir = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/research/commons/") + "/research/".length()));
                referenceDirs.add(URIHelper.resolve(projectsResearchReferenceDir, ReleaseMojo.ReferenceTag.PROJECTS.toString()));
                researchReferenceDir = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/research/commons/")) + "/research/dev/");
                referenceDirs.add(URIHelper.resolve(researchReferenceDir, ReleaseMojo.ReferenceTag.EXPERIMENTAL.toString()));
                productReferenceDir = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/research/commons/")) + "/product/dev/");
                referenceDirs.add(URIHelper.resolve(productReferenceDir, ReleaseMojo.ReferenceTag.STABLE.toString()));
                referenceDirs.add(URIHelper.resolve(productReferenceDir, ReleaseMojo.ReferenceTag.COOKING.toString()));
                referenceDirs.add(URIHelper.resolve(productReferenceDir, ReleaseMojo.ReferenceTag.PROD.toString()));
                bootstrapReferenceDir = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/research/commons/")) + "/product/");
                referenceDirs.add(URIHelper.resolve(bootstrapReferenceDir, ReleaseMojo.ReferenceTag.BOOTSTRAP.toString()));
            }
            if (this.baseDir.toString().contains("/research/projects/")) {
                URI projectsResearchReferenceDir = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/research/projects/") + "/research/".length()));
                referenceDirs.add(URIHelper.resolve(projectsResearchReferenceDir, ReleaseMojo.ReferenceTag.PROJECTS.toString()));
                URI commonsResearchReferenceDir = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/research/projects/")) + "/research/");
                referenceDirs.add(URIHelper.resolve(commonsResearchReferenceDir, ReleaseMojo.ReferenceTag.COMMONS.toString()));
                researchReferenceDir = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/research/projects/")) + "/research/dev/");
                referenceDirs.add(URIHelper.resolve(researchReferenceDir, ReleaseMojo.ReferenceTag.EXPERIMENTAL.toString()));
                productReferenceDir = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/research/projects/")) + "/product/dev/");
                referenceDirs.add(URIHelper.resolve(productReferenceDir, ReleaseMojo.ReferenceTag.STABLE.toString()));
                referenceDirs.add(URIHelper.resolve(productReferenceDir, ReleaseMojo.ReferenceTag.COOKING.toString()));
                referenceDirs.add(URIHelper.resolve(productReferenceDir, ReleaseMojo.ReferenceTag.PROD.toString()));
                bootstrapReferenceDir = URI.create(this.baseDir.toString().substring(0, this.baseDir.toString().indexOf("/research/projects/")) + "/product/");
                referenceDirs.add(URIHelper.resolve(bootstrapReferenceDir, ReleaseMojo.ReferenceTag.BOOTSTRAP.toString()));
            }
            System.out.println("referenceDirs = " + referenceDirs);
            if (referenceDirs.size() != ReleaseMojo.ReferenceTag.values().length) {
                throw new MojoExecutionException("Impossible to detect all integration continuous repository!!!");
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public void getAllInternalSnapshotParentDependencies(Parent parent, List<Dependency> parentDependencies, int i) throws MojoExecutionException {
        try {
            URI location;
            Dependency dep;
            if (parent != null) {
                System.out.println(this.whiteSpace(i) + parent.getArtifactId());
            }
            if (parent != null && parent.getVersion() != null && parent.getVersion().endsWith("SNAPSHOT") && !this.dependencyAlreadyKnow(parentDependencies, dep = new Dependency(parent, location = TreeMojo.findLocation(parent.getGroupId(), parent.getArtifactId(), this.baseDir)))) {
                parentDependencies.add(dep);
                this.getAllInternalSnapshotParentDependencies(dep.getParent(), parentDependencies, i + 3);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public String whiteSpace(int cpt) {
        String res = "";
        for (int i = 0; i < cpt; ++i) {
            res = res + " ";
        }
        return res;
    }

    public void getAllInternalSnapshotChildInDependencies(MavenProject effectiveProject, List<Dependency> childDependencies, int i) throws MojoExecutionException {
        try {
            System.out.println(this.whiteSpace(i) + effectiveProject.getArtifactId());
            ArrayList<Dependency> brotherDependencies = new ArrayList<Dependency>();
            for (org.apache.maven.model.Dependency dependency : effectiveProject.getDependencies()) {
                if (dependency.getVersion() == null || !dependency.getVersion().endsWith("SNAPSHOT") && !this.isAPropertyVersion(dependency.getVersion())) continue;
                URI location = null;
                try {
                    location = TreeMojo.findLocation(dependency.getGroupId(), dependency.getArtifactId(), this.baseDir);
                    Dependency dep = new Dependency(dependency, location);
                    if (this.dependencyAlreadyKnow(childDependencies, dep)) continue;
                    childDependencies.add(dep);
                    brotherDependencies.add(dep);
                }
                catch (MojoExecutionException e) {
                    if (!(!this.baseDir.toString().contains(ReleaseMojo.ReferenceTag.COMMONS.toString()) && !this.baseDir.toString().contains(ReleaseMojo.ReferenceTag.PROJECTS.toString()) || dependency.getGroupId().contains("ebmwebsourcing") || dependency.getGroupId().contains("petalslink") || dependency.getGroupId().contains("linagora"))) {
                        log.warning("Commons or Research projects are not in continuous integration. Some rules are released: \nFor example, this external dependency is in snapshot version: " + dependency.getGroupId() + ":" + dependency.getArtifactId());
                        this.dependenciesToExclude.add(dependency);
                        continue;
                    }
                    throw e;
                }
            }
            for (Dependency dependency : brotherDependencies) {
                this.getAllInternalSnapshotChildInDependencies(dependency.getProjectModel(), childDependencies, i + 3);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public void getAllInternalSnapshotChildInParentDependencies(MavenProject effectiveProject, List<Dependency> parentDependencies, List<Dependency> childDependencies, int i) throws MojoExecutionException {
        try {
            System.out.println(this.whiteSpace(i) + effectiveProject.getArtifactId());
            ArrayList<Dependency> brotherDependencies = new ArrayList<Dependency>();
            for (Dependency parent : parentDependencies) {
                for (org.apache.maven.model.Dependency dependence : parent.getProjectModel().getModel().getDependencies()) {
                    URI location;
                    Dependency dep;
                    if (dependence.getVersion() == null || !dependence.getVersion().endsWith("SNAPSHOT") && !this.isAPropertyVersion(dependence.getVersion()) || this.dependencyAlreadyKnow(childDependencies, dep = new Dependency(dependence, location = TreeMojo.findLocation(dependence.getGroupId(), dependence.getArtifactId(), this.baseDir)))) continue;
                    childDependencies.add(dep);
                    brotherDependencies.add(dep);
                }
            }
            for (Dependency dependence : brotherDependencies) {
                this.getAllInternalSnapshotChildInDependencies(dependence.getProjectModel(), childDependencies, i + 3);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private boolean isAPropertyVersion(String version) {
        if (this.propertyTagContainingSnapshotVersion != null) {
            for (String key : this.propertyTagContainingSnapshotVersion) {
                if (version == null || !version.contains(key)) continue;
                return true;
            }
        }
        return false;
    }

    public static URI findLocation(String groupId, String artifactId, URI baseDir) throws MojoExecutionException {
        URI test;
        for (ReleaseMojo.ReferenceTag tag : ReleaseMojo.ReferenceTag.values()) {
            if (tag == ReleaseMojo.ReferenceTag.COMMONS || tag == ReleaseMojo.ReferenceTag.PROJECTS) continue;
            groupId = groupId.replaceFirst(tag.toString(), "");
        }
        String shortPath = groupId.replace("com.ebmwebsourcing.", "").replace(".", "/") + "/" + artifactId;
        URI res = null;
        for (URI ref : referenceDirs) {
            test = URI.create(ref.toString() + "/" + shortPath + "/pom.xml");
            if (!new File(test).exists()) continue;
            res = test;
        }
        if (res == null) {
            if (shortPath.contains("com/ebmwebsourcing/ebmwebsourcing")) {
                shortPath = "ebmws-pom";
            } else if (shortPath.contains("easywsdl-parent") && groupId.contains("org.ow2.")) {
                shortPath = groupId.replace("org.ow2.", "").replace(".", "/") + "/parent/";
            } else if (shortPath.contains("easywsdl") && groupId.contains("org.ow2.")) {
                shortPath = groupId.replace("org.ow2.", "").replace(".", "/") + "/modules/" + groupId.replace("easywsdl", "") + artifactId.replace("-", ".");
            } else if (shortPath.contains("wsstar/ws-addressing-definition")) {
                shortPath = groupId.replace("com.ebmwebsourcing.", "").replace(".", "/") + "/" + artifactId.replace("-definition", "/definition");
            } else if (shortPath.contains("org/petalslink/corporate/corporate-research-projects-parent")) {
                shortPath = groupId.replace("org.petalslink.", "").replace(".", "/") + "/" + artifactId;
            }
            for (URI ref : referenceDirs) {
                test = URI.create(ref.toString() + "/" + shortPath + "/pom.xml");
                if (!new File(test).exists()) continue;
                res = test;
            }
        }
        if (res == null) {
            if (baseDir.toString().contains(ReleaseMojo.ReferenceTag.COMMONS.toString())) {
                for (ReleaseMojo.ReferenceTag tag : ReleaseMojo.ReferenceTag.values()) {
                    groupId = groupId.replaceFirst(tag.toString(), "");
                }
                shortPath = groupId.replace("com.ebmwebsourcing.", "").replace(".", "/") + "/" + artifactId;
                for (URI ref : referenceDirs) {
                    URI test2 = URI.create(ref.toString() + "/" + shortPath + "/pom.xml");
                    System.out.println("lmlmlmlmlm commons test: " + test2);
                    if (!new File(test2).exists()) continue;
                    res = test2;
                }
            }
            if (res == null && baseDir.toString().contains(ReleaseMojo.ReferenceTag.PROJECTS.toString())) {
                for (ReleaseMojo.ReferenceTag tag : ReleaseMojo.ReferenceTag.values()) {
                    groupId = groupId.replaceFirst(tag.toString(), "");
                }
                shortPath = groupId.replace("com.ebmwebsourcing.", "").replace(".", "/") + "/" + artifactId;
                for (URI ref : referenceDirs) {
                    URI test3 = URI.create(ref.toString() + "/" + shortPath + "/pom.xml");
                    System.out.println("lmlmlmlmlm research test: " + test3);
                    if (!new File(test3).exists()) continue;
                    res = test3;
                }
            }
        }
        if (res == null) {
            throw new MojoExecutionException("Impossible to find this dependence in ci repository: " + groupId + ":" + artifactId + "\nshortPath = " + shortPath);
        }
        return res;
    }

    public boolean dependencyAlreadyKnow(List<Dependency> dependencies, Dependency dependency) {
        for (Dependency dep : dependencies) {
            if (!dep.getGroupId().equals(dependency.getGroupId()) || !dep.getArtifactId().equals(dependency.getArtifactId())) continue;
            return true;
        }
        return false;
    }
}

