/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easytools.plugin.release.impl.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FileUtil {
    public static File[] getAllDirectories(File parentDir) throws Exception {
        ArrayList<File> list = new ArrayList<File>();
        if (parentDir.isDirectory()) {
            list.addAll(Arrays.asList(parentDir.listFiles()));
            for (File current : list) {
                if (!current.isDirectory()) continue;
                list.addAll(Arrays.asList(FileUtil.getAllDirectories(current)));
            }
        }
        return list.toArray(new File[list.size()]);
    }

    public static File[] getAllFiles(File parentDir) throws Exception {
        ArrayList<File> list = new ArrayList<File>();
        if (parentDir != null) {
            list.addAll(Arrays.asList(parentDir.listFiles()));
        }
        return list.toArray(new File[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(InputStream source, OutputStream destination) {
        boolean resultat = false;
        InputStream sourceFile = null;
        OutputStream destinationFile = null;
        try {
            int nbLecture;
            sourceFile = source;
            destinationFile = destination;
            byte[] buffer = new byte[524288];
            while ((nbLecture = sourceFile.read(buffer)) != -1) {
                destinationFile.write(buffer, 0, nbLecture);
            }
            resultat = true;
        }
        catch (FileNotFoundException f) {
        }
        catch (IOException e) {
        }
        finally {
            try {
                sourceFile.close();
            }
            catch (Exception e) {}
            try {
                destinationFile.close();
            }
            catch (Exception e) {}
        }
        return resultat;
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileUtil.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    private static File[] getAllDirectoriesRecursif(File parentDir) throws Exception {
        ArrayList<File> list = new ArrayList<File>();
        if (parentDir.isDirectory()) {
            list.addAll(Arrays.asList(parentDir.listFiles()));
            ArrayList<File> listTmp = new ArrayList<File>();
            for (File current : list) {
                if (!current.isDirectory()) continue;
                listTmp.addAll(Arrays.asList(FileUtil.getAllDirectoriesRecursif(current)));
            }
            list.addAll(listTmp);
        }
        return list.toArray(new File[list.size()]);
    }

    private static File[] getAllFilesRecursif(File parentDir) throws Exception {
        ArrayList<File> list = new ArrayList<File>();
        if (parentDir != null) {
            for (File dir : FileUtil.getAllDirectoriesRecursif(parentDir)) {
                File[] fs = dir.listFiles();
                if (fs == null) continue;
                list.addAll(Arrays.asList(fs));
            }
            list.addAll(Arrays.asList(parentDir.listFiles()));
        }
        return list.toArray(new File[list.size()]);
    }

    public static File[] findFilesInDirectory(String shortFileName, File parentDir) throws Exception {
        ArrayList<File> res = new ArrayList<File>();
        List<File> files = Arrays.asList(FileUtil.getAllFilesRecursif(parentDir));
        for (File f : files) {
            if (!f.getName().equals(shortFileName)) continue;
            res.add(f);
        }
        return res.toArray(new File[res.size()]);
    }
}

