/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.api.model.compiler.validation;

import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Error;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Info;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.StaticAnalysisPrinter;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Warning;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractStaticAnalysisPrinter
implements StaticAnalysisPrinter {
    protected AbstractStaticAnalysisPrinter() {
    }

    @Override
    public List<String> printErrorsAsString(List<Error> errors) {
        ArrayList<String> res = new ArrayList<String>();
        for (Error e : errors) {
            res.add(((Throwable)e.getError()).getMessage());
        }
        return res;
    }

    @Override
    public String printAllErrors(List<Error> errors) {
        String res = "";
        for (String s : this.printErrorsAsString(errors)) {
            res = res + s + "\n";
        }
        return res;
    }

    @Override
    public String printAllWarnings(List<Warning> warnings) {
        String res = "";
        for (Warning w : warnings) {
            res = res + w.getWarning() + "\n";
        }
        return res;
    }

    @Override
    public String printAllInfos(List<Info> infos) {
        String res = "";
        for (Info i : infos) {
            res = res + i.getInfo() + "\n";
        }
        return res;
    }

    @Override
    public String printAll(List<Error> errors, List<Warning> warnings, List<Info> infos) {
        String res = "";
        if (infos != null && infos.size() > 0) {
            res = res + infos.size() + " Infos:\n" + this.printAllInfos(infos);
        }
        if (res.length() > 0) {
            res = res + "\n";
        }
        if (warnings != null && warnings.size() > 0) {
            res = res + warnings.size() + " Warnings:\n" + this.printAllWarnings(warnings);
        }
        if (res.length() > 0) {
            res = res + "\n";
        }
        if (errors != null && errors.size() > 0) {
            res = res + errors.size() + " Errors:\n" + this.printAllErrors(errors);
        }
        return res;
    }
}

