/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.api.model.compiler.validation;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractStaticAnalysis implements StaticAnalysis {

//	private static StaticAnalysis analysis = null;
	
	
	public List<Error> errors = new ArrayList<Error>();
	
	public List<Warning> warnings = new ArrayList<Warning>();
	
	public List<Info> infos = new ArrayList<Info>();
	
	
	protected AbstractStaticAnalysis() {
		
	}
	
//	public static StaticAnalysis getInstance() {
//		if(analysis == null) {
//			analysis = new AbstractStaticAnalysis();
//		}
//		return analysis;
//	}
	
	public void addError(final Error e) {
		this.errors.add(e);
	}

	public List<Error> getErrors() {
		return this.errors;
	}

	public void addWarning(final Warning warn) {
		this.warnings.add(warn);
	}

	public List<Warning> getWarnings() {
		return this.warnings;
	}

	public void addInfo(final Info info) {
		this.infos.add(info);
		
	}

	public List<Info> getInfos() {
		return this.infos;
	}
	
	
}
