/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.osoa.sca.annotations.Property;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.AssignBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.AssignementExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Assigner;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=AssignBehaviour.class,names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class AssignBehaviourImpl extends AbstractBehaviourImpl implements
		AssignBehaviour {

	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(AssignBehaviourImpl.class.getName());

	@Property(name="assignements", required=true)
	private List<AssignementExpression> assignements = new ArrayList<AssignementExpression>();

	@Override
	public String toString() {
		return "Assign";
	}


	public void affect() throws CoreException {
		
		if (this.assignements != null) {
		
			for (final AssignementExpression assignement : this.assignements) {
		
				if ((assignement == null) || (assignement.getLeft() == null)) {
					throw new CoreException("The left assignement is null");
				}

		
				
				Assigner assigner = getNode().getExecution().getParentScope().getProcess().getAssigner();
				
				if (assigner == null) {
					throw new CoreException(
							"Error: the assigner cannot be null");
				}
		
				// realized affectation
				this.log.finest("set " + assignement.getRight() + " in "
						+ assignement.getLeft());

				assigner.affect(
						this.getNode().getExecution().getParentScope(),
						assignement.getLeft(), assignement.getRight());

			}
		}
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}

	@Override
	protected void executeOnEnded() throws CoreException {
	}

	@Override
	protected void executeOnInactive() throws CoreException {
		this.log.finest("start assign behaviour on node: " + this.node.getName());
		this.state = State.ACTIVITY_STARTED;
		this.affect();
		this.log.finest("end of assign behaviour on node: " + this.node.getName());
		this.state = State.ACTIVITY_ENDED;
	}

	@Override
	protected void executeOnStarted() throws CoreException {
	}
}
