/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.osoa.sca.annotations.Property;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.SenderBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.FaultHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageAdapter;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=SenderBehaviour.class,names="service")
public class SenderBehaviourImpl extends AbstractBehaviourImpl implements
SenderBehaviour {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(SenderBehaviourImpl.class.getName());

	@Property(name="kind", required=true)
	private Kind kind;

	@Property(name="inputVariableName", required=true)
	private QName inputVariableName;

	@Property(name="outputVariableName", required=true)
	private QName outputVariableName;

	@Property(name="providerEndpointKey", required=false)
	private Object providerEndpointKey;

	@Property(name="operationName", required=false)
	private String operationName;
	
	@Property(name="messageAdapter", required=false)
	private MessageAdapter messageAdapter;

	@Property(name="faultHandler", required=false)
	private FaultHandler faultHandler;
	
	
	@Override
	public String toString() {
		return "Sender Behaviour";
	}

	public void sendTo(final InternalMessage<?> message, final Endpoint endpoint,
			final Map<Endpoint, Map<String, ExternalContext>> context) throws CoreException {
		final com.ebmwebsourcing.easyviper.core.api.engine.Process p = this
		.getNode().getExecution().getParentScope().getProcess();
		p.getEngine().sendTo(message, endpoint, context);
	}

	
	
	@Override
	public InternalMessage<?> sendSyncTo(final InternalMessage<?> request,
			final Endpoint endpoint, final  Map<Endpoint, Map<String, ExternalContext>>  context) throws CoreException {
		final com.ebmwebsourcing.easyviper.core.api.engine.Process p = this
		.getNode().getExecution().getParentScope().getProcess();
		return p.getEngine().sendSyncTo(request, endpoint, context);
	}


	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}


	public CorrelationMatcher getCorrelationMatcher() {
		// TODO Auto-generated method stub
		return null;
	}

	public void setCorrelationMatcher(CorrelationMatcher correlationMatcher) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected void executeOnEnded() throws CoreException {
	}

	@Override
	protected void executeOnInactive() throws CoreException {
		this.log.finest("start sender behaviour on node: " + this.node.getName());
		this.state = State.ACTIVITY_STARTED;
		this.log.finest("execute sender behaviour on node: " + this.node.getName());

		// get the variable in process
		this.log.finest("get the variable : " + this.inputVariableName);
		final Scope scope = this.node.getExecution().getParentScope();
		final Variable inputVariable = scope.findVariable(this.inputVariableName);

		if (inputVariable == null) {
			throw new CoreException("Input Variable "
					+ this.inputVariableName + " not found in behaviour: "
					+ this.getName());
		}

		if (this.kind == null) {
			throw new CoreException("Kind cannot be null");
		}

		if(this.providerEndpointKey != null) {
			Endpoint providerEndpoint = scope
			.findEndpoint(this.providerEndpointKey);

			if(providerEndpoint == null) {
				throw new CoreException("Provider Endpoint cannot be null");
			}

			if(this.operationName != null) {
				providerEndpoint.setInvokedOperation(this.operationName);
			}

			log.finest("send message to " + providerEndpoint.getEndpointName() + " on interface " + providerEndpoint.getInterfaceName() + " on operation " + this.operationName);

			try {
				if (this.kind == Kind.ASYNCHRONOUS) {
					this.log.finest("asynchronous send");
					InternalMessage outputMessage = inputVariable.getValue();
					//outputMessage.setOperationName(getOperationName());
					if(this.messageAdapter != null) {
						outputMessage = this.messageAdapter.adapt(inputVariable);
						log.finest("adapt the message: " + outputMessage);
					}
					outputMessage.setOperationName(providerEndpoint.getInvokedOperation());

					this.sendTo(outputMessage, providerEndpoint, this
							.getNode().getExecution().getParentScope().getProcess()
							.getExternalContexts());
				} else if (this.kind == Kind.SYNCHRONOUS) {
					this.log.finest("synchronous send");
					final Variable outputVariable = scope
					.findVariable(this.outputVariableName);

					if (outputVariable == null) {
						throw new CoreException("Output Variable "
								+ this.outputVariableName + " not found in behaviour: "
								+ this.getName());
					}

					InternalMessage outputMessage = inputVariable.getValue();
					
					if(this.messageAdapter != null) {
						outputMessage = this.messageAdapter.adapt(inputVariable);
						log.finest("adapt the message: " + outputMessage);
					}

					log.finest("operation name : "+this.operationName);

					outputVariable.setValue(this
							.sendSyncTo(outputMessage,
									providerEndpoint, this.getNode()
									.getExecution().getParentScope()
									.getProcess().getExternalContexts()));
				}
			} catch(CoreException e) {
			    this.state = State.ACTIVITY_ENDED;
			    if(this.faultHandler != null) {
					CoreException modelException = this.faultHandler.getModelExceptionFromGenericException(scope, e);
					if (modelException != null) {
						throw modelException;
					} else {
						throw e;
					}
					
				} else {
					log.warning("exception handler is null");
					throw e;
				}
				
			}
		} else {
			this.log.finest("the provider Endpoint Key is null");
		}
		this.log.finest("Message accepted by the received activity: "
				+ this.getName());
		this.state = State.ACTIVITY_ENDED;

	}

	@Override
	protected void executeOnStarted() throws CoreException {
	}
	
	
	@Override
	public void clean() {
	    super.clean();
	    
	}

}
