/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import java.util.Date;
import java.util.logging.Logger;

import org.osoa.sca.annotations.Property;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.WaitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.DateExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.LongExpression;
import com.ebmwebsourcing.easyviper.core.impl.engine.time.WaitingThreadPool;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=WaitBehaviour.class,names="service")
public class WaitBehaviourImpl extends AbstractBehaviourImpl implements WaitBehaviour {

	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(WaitBehaviourImpl.class.getName());

	@Property(name="time", required=false)
	private LongExpression<?> time;

	@Property(name="date", required=false)
	private DateExpression<?> date;

	private boolean alreadyWaited;

	public WaitBehaviourImpl() {

	}

	public LongExpression<?> getDuration() {
		return this.time;
	}

	public void setDuration(final LongExpression<?> time) {
		this.time = time;
	}

	public DateExpression<?> getDate() {
		return this.date;
	}

	public void setDate(DateExpression<?> date) {
		this.date = date;
	}

	@Override
	public String toString() {
		return "WaitActivity";
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}

	@Override
	public void terminateWaiting() throws CoreException {
		alreadyWaited = true;
		notifyParentBehaviour();
	}

	@Override
	protected void executeOnEnded() throws CoreException {
		alreadyWaited = false;
	}

	@Override
	protected void executeOnInactive() throws CoreException {
		if(alreadyWaited) {
			this.state = State.ACTIVITY_ENDED;
			return;
		}

		this.log.finest("start wait behaviour on node: " + this.node.getName());
		this.state = State.ACTIVITY_STARTED;

		Process process = getNode().getExecution().getParentScope().getProcess(); 

		if(this.time != null) {
			Long time = this.time.evaluate(this.getNode().getExecution().getParentScope());
			if(time == null) {
				throw new CoreException("Impossible to evaluate long expression: " + this.time.getContent());
			}
			if(time >=0) {
				this.log.finest("execute wait behaviour on node: " + this.node.getName()
						+ " => wait during " + time + " ms");
				getNode().getExecution().setStateRecursively(Execution.State.SUSPENDED);
				WaitingThreadPool.addWaitingThread(process, this, time);
			}
			else {
				this.state = State.ACTIVITY_ENDED;
				return;
			}
		} else if(this.date != null) {
			Date date = this.date.evaluate(this.getNode().getExecution().getParentScope());
			if(date == null) {
				throw new CoreException("Impossible to evaluate date expression: " + this.date.getContent());
			}
			this.log.finest("execute wait behaviour on node: " + this.node.getName()
					+ " => wait until " + date );

			Long time = date.getTime() - System.currentTimeMillis();
			if(time >=0) {
				this.log.finest("execute wait behaviour on node: " + this.node.getName()
						+ " => wait during " + time + " ms");
				getNode().getExecution().setStateRecursively(Execution.State.SUSPENDED);
				WaitingThreadPool.addWaitingThread(process, this, time);
			}
			else {
				this.state = State.ACTIVITY_ENDED;
				return;
			}
		}
	}

	@Override
	protected void executeOnStarted() throws CoreException {
	}


}