/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyviper.core.impl.marshalling;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.bind.JAXBContext;

import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.impl.SchemaJAXBContext;

import com.ebmwebsourcing.easyviper.core.api.CoreException;


public class ViperJAXBContext {


	private static final List<Object> defaultObjectFactoriesObjects = new ArrayList<Object>();

	private static final List<Class> defaultObjectFactoriesClasses = new ArrayList<Class>(Arrays.asList(new Class[] {
			com.ebmwebsourcing.easyviper.model.ObjectFactory.class
	}));


	public static List<Class> getDefaultObjectFactories() {
		return defaultObjectFactoriesClasses;
	}


	private List<Class> currentObjectFactories = new ArrayList<Class>(defaultObjectFactoriesClasses);


	private static ViperJAXBContext instance = null;

	/**
	 * Private object initializations
	 */
	private ViperJAXBContext() throws CoreException {
		try {
			SchemaJAXBContext.getInstance().addOtherObjectFactory(defaultObjectFactoriesClasses);
			SchemaJAXBContext.getInstance().getJaxbContext();
		} catch (final SchemaException e) {
			throw new CoreException(e);
		}

	}


	public static <F> F getObjectFactory(Class<F> clazz) throws CoreException {
		F res = null;
		Class c = null;
		boolean found = false;
		/*
		 * Check that the clazz parameter belongs the list of factories
		 */
		for(Class current : defaultObjectFactoriesClasses){
			
			if(current.equals(clazz)){
				found=true;
				c = current;
				break;
			}
		}
		if(found){
			
			found = false;
			/*
			 * Check if an object of this class is alreay instanciated, if not create a new instance
			 */
			for(Object o : defaultObjectFactoriesObjects){
				if(o.getClass().equals(clazz)){
					res = (F) o;
					found = true;
					break;
				}
			}
			
			if(!found){
				try {
				
					Constructor constructor = c.getConstructor();
					res = (F) c.newInstance();
				
				} catch (SecurityException e) {
					throw new CoreException(e.getMessage());
				} catch (NoSuchMethodException e) {
					throw new CoreException(e.getMessage());
				} catch (InstantiationException e) {
					throw new CoreException(e.getMessage());
				} catch (IllegalAccessException e) {
					throw new CoreException(e.getMessage());
				}
			}
			
		}else{
			throw new CoreException("The class "+clazz.getName()+" is not in the factories list of EasyViper.");
		}


		return res;
	}

	public static ViperJAXBContext getInstance() throws CoreException {
		if(instance == null) {
			instance = new ViperJAXBContext();
		}
		return instance;
	}



	/**
	 * @return the jaxbContext
	 * @throws WSDLException 
	 */
	public JAXBContext getJaxbContext() throws CoreException {
		try {
			return SchemaJAXBContext.getInstance().getJaxbContext();
		} catch (SchemaException e) {
			throw new CoreException(e);
		}
	}

}
