/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.model.registry;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ProcessKeyImpl implements ProcessKey {

	private QName itf;

	private QName service;

	private String endpoint;

	public ProcessKeyImpl() {
	}

	public ProcessKeyImpl(final QName itf, final QName service, final String endpoint) {
		this.service = service;
		this.endpoint = endpoint;
		this.itf = itf;
	}

	public QName getService() {
		return this.service;
	}

	public void setService(final QName service) {
		this.service = service;
	}

	public String getEndpoint() {
		return this.endpoint;
	}

	public void setEndpoint(final String endpoint) {
		this.endpoint = endpoint;
	}

	public QName getInterface() {
		return this.itf;
	}

	public void setInterface(final QName itf) {
		this.itf = itf;
	}

	@Override
	public String toString() {
		return "[::interface=" + this.itf + "|::endpoint=" + this.endpoint
		+ "|::service=" + this.service + "]";
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
		+ ((this.endpoint == null) ? 0 : this.endpoint.hashCode());
		result = prime * result + ((this.service == null) ? 0 : this.service.hashCode());
		return result;
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (this.getClass() != obj.getClass()) {
			return false;
		}
		final ProcessKeyImpl other = (ProcessKeyImpl) obj;
		if (this.endpoint == null) {
			if (other.endpoint != null) {
				return false;
			}
		} else if (!this.endpoint.equals(other.endpoint)) {
			return false;
		}
		if (this.service == null) {
			if (other.service != null) {
				return false;
			}
		} else if (!this.service.equals(other.service)) {
			return false;
		}
		return true;
	}

	

}
