/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.pattern.creation;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.LongExpression;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReceiverBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.WaitBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.test.util.GenericFactory;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.easyviper.tools.SysoutSenderImpl;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class ExclusivePatternTest {
    private static final int timeout = 25000;

    @BeforeClass
    public static void init() {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
        try {
            LogManager.getLogManager().readConfiguration(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @AfterClass
    public static void tearDown() {
        LogManager.getLogManager().reset();
    }

    @Test
    public void testExclusiveWithoutChildPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: 0 child");
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ExclusiveProcess"), null);
        Node initial = CreationPatternFactory.getInstance().createExclusivePattern("exclusive", null, (Scope)process);
        process.setInitialNode(initial);
        Execution execution = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        execution.runStepByStep();
        Assert.assertEquals((String)"node_supporting_exclusive", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_exclusive", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testExclusiveWitOneChildPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: 1 empty");
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ExclusiveProcess"), null);
        HashMap<Node, Object> childNodes = new HashMap<Node, Object>();
        childNodes.put(process.createNode("first", EmptyBehaviourImpl.class, null), null);
        Node initial = CreationPatternFactory.getInstance().createExclusivePattern("exclusive", childNodes, (Scope)process);
        process.setInitialNode(initial);
        Node finalNode = process.createNode("final", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(initial, finalNode);
        Execution execution = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_exclusive", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_exclusive", (String)process.getParentExecution().getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)process.getParentExecution().getState());
        execution.signal();
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_final", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testExclusiveWithTwoWaitChildren() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: 2 waits");
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ExclusiveProcess"), null);
        Node beforeExclusive = process.createNode("beforeExclusive", EmptyBehaviourImpl.class, null);
        HashMap<String, LongExpressionImpl> context = new HashMap<String, LongExpressionImpl>();
        context.put("time", new LongExpressionImpl(new Long(5000L)));
        Node first = process.createNode("first", WaitBehaviourImpl.class, context);
        Node afterFirst = process.createNode("afterFirst", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(first, afterFirst);
        context = new HashMap();
        context.put("time", new LongExpressionImpl(new Long(10000L)));
        Node second = process.createNode("second", WaitBehaviourImpl.class, context);
        Node afterSecond = process.createNode("afterSecond", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(second, afterSecond);
        HashMap<Node, Node> childNodes = new HashMap<Node, Node>();
        childNodes.put(first, afterFirst);
        childNodes.put(second, afterSecond);
        Node exclusive = CreationPatternFactory.getInstance().createExclusivePattern("exclusive", childNodes, (Scope)process);
        Node afterExclusive = process.createNode("afterExclusive", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(beforeExclusive, exclusive);
        process.linkedBrotherNodes(exclusive, afterExclusive);
        process.setInitialNode(beforeExclusive);
        Execution execution = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        long start = System.currentTimeMillis();
        process.run();
        while (!process.getParentExecution().getState().equals((Object)Execution.State.ENDED)) {
            if (System.currentTimeMillis() - start > 25000L) {
                Assert.fail((String)("TIMED OUT " + (System.currentTimeMillis() - start) + "  " + process.getParentExecution().getState()));
            }
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_afterExclusive", (String)process.getParentExecution().getCurrentTarget().getName());
        Assert.assertEquals((Object)Behaviour.State.ACTIVITY_ENDED, (Object)afterFirst.getBehaviour().getState());
    }

    @Test
    public void testExclusiveWithWaitAndMessageChildren() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: wait & message");
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ExclusiveProcess"), null);
        Node beforeExclusive = process.createNode("beforeExclusive", EmptyBehaviourImpl.class, null);
        HashMap<String, LongExpressionImpl> context = new HashMap<String, LongExpressionImpl>();
        context.put("time", new LongExpressionImpl(new Long(5000L)));
        Node first = process.createNode("first", WaitBehaviourImpl.class, context);
        Node afterFirst = process.createNode("afterFirst", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(first, afterFirst);
        Node second = process.createNode("second", ReceiverBehaviourImpl.class, null);
        Node afterSecond = process.createNode("afterSecond", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(second, afterSecond);
        HashMap<Node, Node> childNodes = new HashMap<Node, Node>();
        childNodes.put(first, afterFirst);
        childNodes.put(second, afterSecond);
        Node exclusive = CreationPatternFactory.getInstance().createExclusivePattern("exclusive", childNodes, (Scope)process);
        Node afterExclusive = process.createNode("afterExclusive", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(beforeExclusive, exclusive);
        process.linkedBrotherNodes(exclusive, afterExclusive);
        process.setInitialNode(beforeExclusive);
        Execution execution = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        long start = System.currentTimeMillis();
        process.run();
        while (!process.getParentExecution().getState().equals((Object)Execution.State.ENDED)) {
            if (System.currentTimeMillis() - start > 25000L) {
                Assert.fail((String)("TIMED OUT " + (System.currentTimeMillis() - start) + " " + process.getParentExecution().getName() + "  " + process.getParentExecution().getState()));
            }
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_afterExclusive", (String)process.getParentExecution().getCurrentTarget().getName());
        Assert.assertEquals((Object)Behaviour.State.ACTIVITY_ENDED, (Object)afterFirst.getBehaviour().getState());
    }

    public class LongExpressionImpl
    implements LongExpression<String> {
        private Long l = null;

        public LongExpressionImpl(Long l) {
            this.l = l;
        }

        public void setLog(Logger logger) {
        }

        public Long evaluate(Scope scope) throws CoreException {
            return this.l;
        }

        public String getContent() {
            return null;
        }

        public void setContent(String content) {
        }

        public Expression<String, Long> copypaste() {
            return null;
        }
    }
}

