/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.service;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.env.Receiver;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReceiverBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.ExternalMessageImpl;
import com.ebmwebsourcing.easyviper.core.impl.test.util.GenericFactory;
import com.ebmwebsourcing.easyviper.core.impl.test.util.StringVariableImpl;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.easyviper.tools.SysoutSenderImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class AutoFlushServiceTest {
    @Test
    public void testAutoFlushService() throws CoreException, NoSuchInterfaceException, InterruptedException {
        boolean explorer = false;
        ConfigurationEngineImpl conf = new ConfigurationEngineImpl();
        conf.setAutoFlushMessageFreqeuency(Integer.valueOf(1000));
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)conf, 1, MemoryReceiverImpl.class, 1, SysoutSenderImpl.class, null);
        Engine engine = core.getEngine();
        ExternalMessageImpl message = new ExternalMessageImpl();
        message.setContent((Object)"hello world!");
        ((Receiver)core.getExternalEnvironment().getReceivers().get(0)).accept((ExternalMessage)message, null);
        core.getEngine().getServiceManager().shutdownAllServices();
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Process process1 = this.createProcess(new QName("Process1"), core);
        process1.run();
        while (process1.getParentExecution().getState() != Execution.State.SUSPENDED) {
            Thread.sleep(100L);
        }
        core.getEngine().getServiceManager().restartAllServices();
        long start = System.currentTimeMillis();
        while (!process1.getParentExecution().getState().equals((Object)Execution.State.ENDED) && System.currentTimeMillis() - start <= 10000L) {
            System.out.println("Wait the auto flush");
            Thread.sleep(500L);
        }
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process1.getParentExecution().getState());
    }

    private Process createProcess(QName name, Core core) throws CoreException {
        StringVariableImpl v1 = new StringVariableImpl();
        v1.setQName(new QName("v1"));
        Process process = core.getEngine().createNewEmptyProcessInstance(name, null);
        process.getVariables().put(v1.getQName(), v1);
        HashMap<String, List<QName>> context = new HashMap<String, List<QName>>();
        context.put("variableNames", Arrays.asList(v1.getQName()));
        Node receiver = process.createNode("receive", ReceiverBehaviourImpl.class, context);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(receiver);
        Node sequence = CreationPatternFactory.getInstance().createSequencePattern("seq", childNodes, (Scope)process);
        process.setInitialNode(sequence);
        return process;
    }
}

