/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ExclusiveBehaviour;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;

@Scope(value="COMPOSITE")
@Service(value={ExclusiveBehaviour.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class ExclusiveBehaviourImpl
extends AbstractBehaviourImpl
implements ExclusiveBehaviour {
    private Logger log = Logger.getLogger(ExclusiveBehaviourImpl.class.getName());
    @Property(name="triggeringNodes", required=false)
    private Set<Node> triggeringNodes;
    @Property(name="alreadyNotified", required=false)
    private boolean alreadyNotified = false;

    protected void executeOnEnded() throws CoreException {
        this.getNode().selectDefaultNextTarget();
    }

    protected void executeOnInactive() throws CoreException {
        this.state = Behaviour.State.ACTIVITY_STARTED;
        this.alreadyNotified = false;
        if (this.triggeringNodes == null || this.triggeringNodes.isEmpty()) {
            this.state = Behaviour.State.ACTIVITY_ENDED;
            return;
        }
        try {
            SCAHelper.getSCAHelper().startComponentAndSubComponents(this.getNode().getExecution().getParentScope().getComponent());
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        block2: for (Node child : this.getNode().getChildNodes()) {
            for (Node triggeringNode : this.triggeringNodes) {
                if (!triggeringNode.getName().equals(child.getName())) continue;
                nodes.add(child);
                continue block2;
            }
        }
        this.getNode().getExecution().setNextExecutableElements((SCAComponent)this, nodes);
    }

    protected void executeOnStarted() throws CoreException {
        if (this.getNode().getExecution().getChildExecutions().isEmpty()) {
            this.log.finest("End of exclusive behaviour.");
            this.state = Behaviour.State.ACTIVITY_ENDED;
        }
    }

    public synchronized void onChildBehaviourNotification(Behaviour childBehaviour) throws CoreException {
        if (this.alreadyNotified) {
            return;
        }
        this.alreadyNotified = true;
        this.log.finest("Notification received from " + childBehaviour.getName());
        String execName = childBehaviour.getNode().getExecution().getName();
        for (Execution childExec : this.getNode().getExecution().getChildExecutions()) {
            if (execName.equals(childExec.getName())) continue;
            this.log.finest(String.valueOf(childExec.getName()) + " has been cancelled");
            childExec.setState(Execution.State.CANCELLED);
            this.getNode().getExecution().removeChildExecution(childExec);
        }
    }
}

