package com.ebmwebsourcing.easyviper.core.impl.engine.time;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.WaitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.time.TimerFinishedEvent;

public class WaitingThreadPool {

	private static Logger log = Logger.getLogger(WaitingThreadPool.class.getName());
	
	private static WaitingThreadPool instance;
	
	private static Map<Process,List<WaitingThread>> threads = Collections.synchronizedMap(new HashMap<Process,List<WaitingThread>>());
	private static Map<Process,List<CoreException>> exceptions = Collections.synchronizedMap(new HashMap<Process,List<CoreException>>());
	
	private WaitingThreadPool() {}
	
	public static synchronized void addWaitingThread(Process proc, WaitBehaviour waitBehaviour, long timeToWait) {
		WaitingThread wt = getInstance().new WaitingThread(proc, waitBehaviour, timeToWait);
		if(!threads.containsKey(proc)) {
			threads.put(proc,new ArrayList<WaitingThread>());
		}
		threads.get(proc).add(wt);
		
		log.finest("new Waiting thread for "+waitBehaviour.getName()+" "+timeToWait);
		
		wt.start();
	}
	
	public static synchronized void removeWaitingThread(Process proc, WaitBehaviour wb) {
		if(threads.containsKey(proc)) {
			WaitingThread toBeRemoved = null;
			for(WaitingThread wt : threads.get(proc)) {
				if(wt.behaviour.equals(wb)) {
					toBeRemoved = wt;
					break;
				}
			}
			threads.get(proc).remove(toBeRemoved);
		}
		
		//TODO also stop the thread
	}
	
	private synchronized void onWaitTermination(Process p, WaitBehaviour b) {
		if(threads.containsKey(p)) {
			threads.get(p).remove(Thread.currentThread());
			try {
				p.getEngine().onTimerFinish(new TimerFinishedEvent(p,b));
			} catch (CoreException e) {
				// TODO maybe end the process or at least notify the engine
				e.printStackTrace();
				addException(p, e);
			}
		}
	}
	
//	private synchronized void onWaitTermination(Process p, Exception ex) {
//		if(threads.containsKey(p)) {
//			try {
//				p.getEngine().onTimerFinish(new TimerFinishedEvent(ex));
//			} catch (CoreException e) {
//				// TODO maybe end the process or at least notify the engine
//				e.printStackTrace();
//				addException(p, e);
//			}
//			threads.get(p).remove(Thread.currentThread());
//		}
//	}
	
	private void addException(Process p, CoreException e) {
		if(!exceptions.containsKey(p)) {
			exceptions.put(p, new ArrayList<CoreException>());
		}
		exceptions.get(p).add(e);
	}
	
	private class WaitingThread extends Thread {
		
		private Process process;
		private WaitBehaviour behaviour;
		private long time;
	
		protected WaitingThread(Process p, WaitBehaviour wb, long timeToWait) {
			this.time = timeToWait;
			this.behaviour = wb;
			this.process = p;
		}
		
		@Override
		public void run() {
			try {
				Thread.sleep(time);
				log.finest("Sleep ended for "+behaviour.getName());
			} catch (InterruptedException e) {
//				WaitingThreadPool.this.onWaitTermination(process,e);
				return;
			}
			WaitingThreadPool.this.onWaitTermination(process,behaviour);
		}
	}
	
	private static WaitingThreadPool getInstance() {
		if(instance == null) {
			instance = new WaitingThreadPool();
		}
		return instance;
	}
}
