/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.api;

import org.objectweb.fractal.fraclet.annotations.Interface;

import com.ebmwebsourcing.easyviper.core.api.engine.Element;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalEnvironment;
import com.ebmwebsourcing.easyviper.core.api.model.Model;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageFactory;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Interface(name = "service")
public interface Core extends Element {

	Engine createEngine(ConfigurationEngine conf, Class internalMessageType) throws CoreException;

	Engine getEngine() throws CoreException;

	Model createModel(String name, Class<? extends Model> modelClass)
			throws CoreException;

	Model getModel() throws CoreException;

	ExternalEnvironment createExternalEnvironment(String name)
			throws CoreException;

	ExternalEnvironment getExternalEnvironment() throws CoreException;

	void setMessageFactory(MessageFactory<ExternalMessage<?>, InternalMessage<?>> messageFactory) throws CoreException;
	
	MessageFactory<ExternalMessage<?>, InternalMessage<?>> getMessageFactory();
}
