/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AutoFlushMessageService;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AutoTrashProcessService;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalEnvironment;
import com.ebmwebsourcing.easyviper.core.api.model.Model;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageFactory;
import com.ebmwebsourcing.easyviper.core.fractal.Binding;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.core.impl.engine.EngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.thread.service.AutoFlushMessageServiceImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.thread.service.AutoTrashProcessServiceImpl;
import com.ebmwebsourcing.easyviper.core.impl.env.ExternalEnvironmentImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.extensions.Membrane;
import org.objectweb.fractal.fraclet.types.Step;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Membrane(controller="composite")
public class CoreImpl
implements Core,
BindingController,
LifeCycleController {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_ENGINE_NAME = "WorkflowEngine";
    private Logger log = Logger.getLogger(CoreImpl.class.getCanonicalName());
    private org.objectweb.fractal.api.Component engineComponent;
    private org.objectweb.fractal.api.Component modelComponent;
    private org.objectweb.fractal.api.Component externalEnvironmentComponent;
    private MessageFactory<ExternalMessage<?>, InternalMessage<?>> messageFactory;
    @Controller
    private org.objectweb.fractal.api.Component component;

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.listFc(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void listFc(List<String> list) {
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    protected void createFc() throws Throwable {
        this.create();
    }

    public String getFcState() {
        return null;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("component")) {
            this.component = (org.objectweb.fractal.api.Component)((org.objectweb.fractal.api.Component)object).getFcInterface("component");
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void unbindFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroyFc();
    }

    protected void destroyFc() throws Throwable {
        this.destroy();
    }

    @Lifecycle(step=Step.CREATE)
    public void create() throws CoreException {
        this.log.fine("Fractal scope created: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    public void init(org.objectweb.fractal.api.Component component) throws CoreException {
        this.component = component;
        this.log.fine("Fractal scope initiated: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Lifecycle(step=Step.START)
    public void start() throws CoreException {
        this.log.fine("Fractal scope started: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Lifecycle(step=Step.STOP)
    public void stop() throws CoreException {
        this.log.fine("Fractal scope stopped: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Lifecycle(step=Step.DESTROY)
    public void destroy() throws CoreException {
        this.log.fine("Fractal scope destroyed: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    public Engine createEngine(ConfigurationEngine configurationEngine, Class clazz) throws CoreException {
        if (this.engineComponent != null) {
            throw new CoreException("Error: Workflow engine already exist!!!");
        }
        Engine engine = null;
        this.engineComponent = FractalHelper.getFractalHelper().createNewComponent(EngineImpl.class.getName(), null);
        FractalHelper.getFractalHelper().addComponent(this.engineComponent, this.component, null);
        try {
            Object object2;
            engine = (Engine)this.engineComponent.getFcInterface("/content");
            engine.init(this.engineComponent);
            engine.setInternalMessageType(clazz);
            if (!this.log.getName().equals(CoreImpl.class.getName())) {
                engine.setLog(this.log);
            }
            FractalHelper.getFractalHelper().startComponent(this.engineComponent);
            FractalHelper.getFractalHelper().changeName(this.engineComponent, DEFAULT_ENGINE_NAME);
            engine = (Engine)this.engineComponent.getFcInterface("service");
            if (configurationEngine.getAutoFlushMessageFrequency() != null && configurationEngine.getAutoFlushMessageFrequency() > 0) {
                object2 = (AutoFlushMessageService)engine.getServiceManager().getService(AutoFlushMessageServiceImpl.class);
                object2.setRefreshFrequency(configurationEngine.getAutoFlushMessageFrequency().intValue());
                engine.getServiceManager().activateService(AutoFlushMessageServiceImpl.class);
            }
            if (configurationEngine.getAutoTrashProcessFrequency() != null && configurationEngine.getAutoTrashProcessFrequency() > 0) {
                object2 = (AutoTrashProcessService)engine.getServiceManager().getService(AutoTrashProcessServiceImpl.class);
                object2.setRefreshFrequency(configurationEngine.getAutoTrashProcessFrequency().intValue());
                engine.getServiceManager().activateService(AutoTrashProcessServiceImpl.class);
            }
            if (configurationEngine.getAdditionnalServices() != null) {
                for (Object object2 : configurationEngine.getAdditionnalServices()) {
                    engine.getServiceManager().addService((Class)object2);
                }
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        this.log.finest("workflow engine created and started");
        return engine;
    }

    public org.objectweb.fractal.api.Component getComponent() {
        return this.component;
    }

    public String getName() throws CoreException {
        return FractalHelper.getFractalHelper().getName(this.component);
    }

    public void setName(String string) throws CoreException {
        if (string != null) {
            FractalHelper.getFractalHelper().changeName(this.component, string);
        }
    }

    public Engine getEngine() throws CoreException {
        Engine engine = null;
        try {
            if (this.engineComponent != null) {
                engine = (Engine)this.engineComponent.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        return engine;
    }

    public Model createModel(String string, Class<? extends Model> clazz) throws CoreException {
        if (this.modelComponent != null) {
            throw new CoreException("Error: Model already exist!!!");
        }
        Model model = null;
        this.modelComponent = FractalHelper.getFractalHelper().createNewComponent(clazz.getName(), null);
        FractalHelper.getFractalHelper().addComponent(this.modelComponent, this.component, null);
        try {
            model = (Model)this.modelComponent.getFcInterface("/content");
            model.init(this.modelComponent);
            if (!this.log.getName().equals(CoreImpl.class.getName())) {
                model.setLog(this.log);
            }
            FractalHelper.getFractalHelper().startComponent(this.modelComponent);
            FractalHelper.getFractalHelper().changeName(this.modelComponent, string);
            model = (Model)this.modelComponent.getFcInterface("service");
            if (model != null) {
                ArrayList<Binding> arrayList = new ArrayList<Binding>();
                arrayList.add(new Binding("model", (Interface)model));
                FractalHelper.getFractalHelper().addBindings(this.engineComponent, arrayList);
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        this.log.finest("model created and started");
        return model;
    }

    public Model getModel() throws CoreException {
        Model model = null;
        try {
            if (this.modelComponent != null) {
                this.modelComponent.getFcInterface("service");
                model = (Model)this.modelComponent.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        return model;
    }

    public ExternalEnvironment createExternalEnvironment(String string) throws CoreException {
        ExternalEnvironment externalEnvironment = null;
        if (this.getEngine() == null) {
            throw new CoreException("You must create the engine before create an external environment!!!");
        }
        org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().createNewComponent(ExternalEnvironmentImpl.class.getName(), null);
        FractalHelper.getFractalHelper().addComponent(component, this.component, null);
        this.externalEnvironmentComponent = component;
        try {
            ArrayList<Binding> arrayList;
            if (this.getEngine() != null) {
                arrayList = new ArrayList<Binding>();
                arrayList.add(new Binding("engine", (Interface)this.getEngine()));
                FractalHelper.getFractalHelper().addBindings(this.externalEnvironmentComponent, arrayList);
            }
            externalEnvironment = (ExternalEnvironment)component.getFcInterface("/content");
            externalEnvironment.init(component);
            if (!this.log.getName().equals(CoreImpl.class.getName())) {
                externalEnvironment.setLog(this.log);
            }
            FractalHelper.getFractalHelper().startComponent(component);
            FractalHelper.getFractalHelper().changeName(component, string);
            externalEnvironment = (ExternalEnvironment)component.getFcInterface("service");
            arrayList = new ArrayList();
            arrayList.add(new Binding("externalEnv", (Interface)externalEnvironment));
            FractalHelper.getFractalHelper().addBindings(this.engineComponent, arrayList);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        this.log.finest("external Environment created and started");
        return externalEnvironment;
    }

    public ExternalEnvironment getExternalEnvironment() throws CoreException {
        ExternalEnvironment externalEnvironment = null;
        try {
            if (this.externalEnvironmentComponent != null) {
                this.externalEnvironmentComponent.getFcInterface("service");
                externalEnvironment = (ExternalEnvironment)this.externalEnvironmentComponent.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        return externalEnvironment;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }

    public MessageFactory<ExternalMessage<?>, InternalMessage<?>> getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(MessageFactory<ExternalMessage<?>, InternalMessage<?>> messageFactory) throws CoreException {
        this.messageFactory = messageFactory;
    }
}

