/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.ExecutableElement;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.LoopBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.ConditionalExpression;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@Interface(name="service", signature=LoopBehaviour.class)})
public class LoopBehaviourImpl
extends AbstractBehaviourImpl
implements LoopBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(LoopBehaviourImpl.class.getName());
    @Requires(contingency=Contingency.OPTIONAL, name="node")
    protected Node node;
    private ConditionalExpression condition;
    private boolean applyConditionAtBegin = true;

    protected void listFc(List<String> list) {
        if (this.node != null) {
            list.add("node");
        }
        super.listFc(list);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            return this.node;
        }
        return super.lookupFc(string);
    }

    public Map<String, Object> getInitializationContext() throws CoreException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("condition", this.condition);
        hashMap.put("applyConditionAtBegin", this.applyConditionAtBegin);
        return hashMap;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = (Node)object;
            return;
        }
        super.bindFc(string, object);
    }

    public void setInitializationContext(Map<String, Object> map) throws CoreException {
        this.condition = (ConditionalExpression)map.get("condition");
        this.applyConditionAtBegin = (Boolean)map.get("applyConditionAtBegin");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = null;
            return;
        }
        super.unbindFc(string);
    }

    public void executeActivity() throws CoreException {
        if (this.state == Behaviour.State.ACTIVITY_INACTIVE) {
            this.state = Behaviour.State.ACTIVITY_STARTED;
            if (this.applyConditionAtBegin) {
                this.log.finest("start while behaviour on node: " + this.node.getName());
                this.whileExecution();
            } else {
                this.log.finest("start repeat until behaviour on node: " + this.node.getName());
                this.repeatUntilExecution(true);
            }
        } else if (this.state == Behaviour.State.ACTIVITY_STARTED) {
            if (this.applyConditionAtBegin) {
                this.whileExecution();
            } else {
                this.repeatUntilExecution(false);
            }
        }
    }

    private void whileExecution() throws CoreException {
        Boolean bl = (Boolean)this.condition.evaluate(this.getNode().getExecution().getParentScope());
        if (bl != null && bl.booleanValue()) {
            List list = this.node.getChildNodes();
            if (list != null && list.size() > 0) {
                this.getNode().getNextSelectedExecutableElements().add((ExecutableElement)list.get(0));
            }
        } else {
            this.log.finest("end while behaviour on node: " + this.node.getName());
            this.state = Behaviour.State.ACTIVITY_ENDED;
            this.getNode().getNextSelectedExecutableElements().clear();
        }
    }

    private void repeatUntilExecution(boolean bl) throws CoreException {
        Object object;
        boolean bl2 = true;
        if (!(bl || (object = (Boolean)this.condition.evaluate(this.getNode().getExecution().getParentScope())) != null && ((Boolean)object).booleanValue())) {
            this.log.finest("end repeat until behaviour on node: " + this.node.getName());
            this.state = Behaviour.State.ACTIVITY_ENDED;
            this.getNode().getNextSelectedExecutableElements().clear();
            bl2 = false;
        }
        if (bl2 && (object = this.node.getChildNodes()) != null && object.size() > 0) {
            this.getNode().getNextSelectedExecutableElements().add((ExecutableElement)object.get(0));
        }
    }

    public Node getNode() {
        return this.node;
    }

    public String toString() {
        return "Sequence";
    }

    public ConditionalExpression getCondition() {
        return this.condition;
    }

    public void setCondition(ConditionalExpression conditionalExpression) {
        this.condition = conditionalExpression;
    }

    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    public boolean getApplyConditionAtBegin() {
        return this.applyConditionAtBegin;
    }

    public void setApplyConditionAtBegin(boolean bl) {
        this.applyConditionAtBegin = bl;
    }
}

