/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.WaitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.DateExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.LongExpression;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@Interface(name="service", signature=WaitBehaviour.class)})
public class WaitBehaviourImpl
extends AbstractBehaviourImpl
implements WaitBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(WaitBehaviourImpl.class.getName());
    @Requires(contingency=Contingency.OPTIONAL, name="node")
    protected Node node;
    private LongExpression<?> time;
    private DateExpression<?> date;

    protected void listFc(List<String> list) {
        if (this.node != null) {
            list.add("node");
        }
        super.listFc(list);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            return this.node;
        }
        return super.lookupFc(string);
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = (Node)object;
            return;
        }
        super.bindFc(string, object);
    }

    public Map<String, Object> getInitializationContext() throws CoreException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("time", this.time);
        hashMap.put("date", this.date);
        return hashMap;
    }

    public void setInitializationContext(Map<String, Object> map) throws CoreException {
        this.time = (LongExpression)map.get("time");
        this.date = (DateExpression)map.get("date");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = null;
            return;
        }
        super.unbindFc(string);
    }

    public void executeActivity() throws CoreException {
        block7: {
            this.log.finest("start wait behaviour on node: " + this.node.getName());
            this.state = Behaviour.State.ACTIVITY_STARTED;
            try {
                if (this.time != null) {
                    Long l = (Long)this.time.evaluate(this.getNode().getExecution().getParentScope());
                    if (l == null) {
                        throw new CoreException("Impossible to evaluate long expression: " + this.time.getContent());
                    }
                    this.log.finest("execute wait behaviour on node: " + this.node.getName() + " => wait during " + l + " ms");
                    Thread.sleep(l);
                    this.log.finest("wait finished");
                    break block7;
                }
                if (this.date == null) break block7;
                try {
                    Date date = (Date)this.date.evaluate(this.getNode().getExecution().getParentScope());
                    if (date == null) {
                        throw new CoreException("Impossible to evaluate date expression: " + this.date.getContent());
                    }
                    this.log.finest("execute wait behaviour on node: " + this.node.getName() + " => wait until " + date);
                    Thread.sleep(date.getTime() - System.currentTimeMillis());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.log.warning("wait behaviour: " + illegalArgumentException.getMessage());
                }
                this.log.finest("wait finished");
            }
            catch (InterruptedException interruptedException) {
                throw new CoreException((Throwable)interruptedException);
            }
        }
    }

    public LongExpression<?> getDuration() {
        return this.time;
    }

    public void setDuration(LongExpression<?> longExpression) {
        this.time = longExpression;
    }

    public DateExpression<?> getDate() {
        return this.date;
    }

    public void setDate(DateExpression<?> dateExpression) {
        this.date = dateExpression;
    }

    public Node getNode() {
        return this.node;
    }

    public String toString() {
        return "WaitActivity";
    }

    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }
}

